package com.scandocai.scandocsdk.models

import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@Serializable
internal data class ExtractionResponse(
    @SerialName("InfoCode") val infoCode: String?,
    @SerialName("Errors") val errors: List<String>?,
    @SerialName("Warnings") val warnings: List<String>?,
    @SerialName("Data") val data: ExtractionDataResponse?,
    @SerialName("ImageData") val imageData: ExtractionImageDataResponse?
)

@Serializable
internal data class ExtractionDataResponse(
    @SerialName("Name") val name: ExtractionFieldDataResponse?,
    @SerialName("Surname") val surname: ExtractionFieldDataResponse?,
    @SerialName("BirthDate") val birthDate: ExtractionFieldDataResponse?,
    @SerialName("Gender") val gender: ExtractionFieldDataResponse?,
    @SerialName("PlaceOfBirth") val placeOfBirth: ExtractionFieldDataResponse?,
    @SerialName("Nationality") val nationality: ExtractionFieldDataResponse?,
    @SerialName("DocumentNumber") val documentNumber: ExtractionFieldDataResponse?,
    @SerialName("IssuedDate") val issuedDate: ExtractionFieldDataResponse?,
    @SerialName("ExpiryDate") val expiryDate: ExtractionFieldDataResponse?,
    @SerialName("CountryOfIssue") val countryOfIssue: ExtractionFieldDataResponse?,
    @SerialName("IssuingAuthority") val issuingAuthority: ExtractionFieldDataResponse?,
    @SerialName("AddressCountry") val addressCountry: ExtractionFieldDataResponse?,
    @SerialName("AddressZip") val addressZip: ExtractionFieldDataResponse?,
    @SerialName("AddressCity") val addressCity: ExtractionFieldDataResponse?,
    @SerialName("AddressCounty") val addressCounty: ExtractionFieldDataResponse?,
    @SerialName("AddressStreet") val addressStreet: ExtractionFieldDataResponse?,
    @SerialName("PersonalIdentificationNumber") val personalIdentificationNumber: ExtractionFieldDataResponse?,
    @SerialName("GivenName") val givenName: ExtractionFieldDataResponse?,
    @SerialName("FamilyName") val familyName: ExtractionFieldDataResponse?,
    @SerialName("MothersGivenName") val mothersGivenName: ExtractionFieldDataResponse?,
    @SerialName("MothersFamilyName") val mothersFamilyName: ExtractionFieldDataResponse?,
    @SerialName("SecondLastName") val secondLastName: ExtractionFieldDataResponse?,
    @SerialName("Address") val address: ExtractionFieldDataResponse?,
    @SerialName("PlaceOfIssue") val placeOfIssue: ExtractionFieldDataResponse?,
    @SerialName("FathersGivenName") val fathersGivenName: ExtractionFieldDataResponse?,
    @SerialName("FathersFamilyName") val fathersFamilyName: ExtractionFieldDataResponse?
)

@Serializable
internal data class ExtractionFieldDataResponse(
    @SerialName("Read") val read: Boolean?,
    @SerialName("Validated") val validated: Boolean?,
    @SerialName("RecommendedValue") val recommendedValue: String?,
    @SerialName("MRZ") val mrz: ExtractionFieldDataMethodResponse?,
    @SerialName("OCR") val ocr: ExtractionFieldDataMethodResponse?
)

@Serializable
internal data class ExtractionFieldDataMethodResponse(
    @SerialName("Read") val read: Boolean?,
    @SerialName("Validated") val validated: Boolean?,
    @SerialName("Value") val value: String?
)

@Serializable
internal data class ExtractionImageDataResponse(
    @SerialName("Documents") val documents: List<String>?,
    @SerialName("FaceImage") val faceImage: String?,
    @SerialName("Signature") val signature: String?
)
