package com.scandocai.scandocsdk.utils

import android.graphics.Bitmap
import android.util.Base64
import java.io.ByteArrayOutputStream

fun Bitmap.encodeToBase64(): String {
    val byteArrayOutputStream = ByteArrayOutputStream()
    val copy: Bitmap = copy(getConfig(), true)
    copy.compress(Bitmap.CompressFormat.PNG, 100, byteArrayOutputStream)
    val byteArray = byteArrayOutputStream.toByteArray()

    return Base64.encodeToString(byteArray, Base64.NO_WRAP)
}