package com.scandocai.scandocsdk.utils

internal sealed class Result<out Success, out Failure> {
    data class Success<out Success>(val value: Success) : Result<Success, Nothing>()
    data class Failure<out Failure>(val error: Failure) : Result<Nothing, Failure>()

    companion object {
        fun <Success> success(value: Success): Result<Success, Nothing> = Success(value)
        fun <Failure> failure(error: Failure): Result<Nothing, Failure> = Failure(error)
    }

    fun getOrNull(): Success? {
        return when (this) {
            is Result.Failure -> null
            is Result.Success -> value
        }
    }

    fun errorOrNull(): Failure? {
        return when (this) {
            is Result.Failure -> error
            is Result.Success -> null
        }
    }
}