/*
 * Decompiled with CFR 0.152.
 */
package ai.sklearn4j.core.libraries;

import ai.sklearn4j.core.libraries.numpy.Numpy;
import ai.sklearn4j.core.libraries.numpy.NumpyArray;
import ai.sklearn4j.core.libraries.numpy.NumpyArrayFactory;

public class Scipy {
    public static NumpyArray<Double> logSumExponent(NumpyArray<Double> data, int axis) {
        NumpyArray<Double> aMaxOriginal = Numpy.arrayMax(data, axis);
        NumpyArray<Double> aMax = Scipy.to2DArrayShape(aMaxOriginal);
        aMax.applyToEachElement(value -> {
            if (!Double.isFinite(value)) {
                return 0.0;
            }
            return value;
        });
        NumpyArray tmp = Numpy.exp(Numpy.subtract(data, aMax));
        tmp = Numpy.sum(tmp, axis);
        tmp = Numpy.log(tmp);
        tmp = Numpy.add(tmp, aMaxOriginal);
        return tmp;
    }

    private static NumpyArray<Double> to2DArrayShape(NumpyArray<Double> np) {
        double[] values = (double[])np.getWrapper().getRawArray();
        double[][] result = new double[values.length][1];
        for (int i = 0; i < result.length; ++i) {
            result[i][0] = values[i];
        }
        return NumpyArrayFactory.from(result);
    }
}

