/*
 * Decompiled with CFR 0.152.
 */
package ai.sklearn4j.core.libraries.numpy;

import ai.sklearn4j.core.libraries.numpy.INumpyArrayElementOperation;
import ai.sklearn4j.core.libraries.numpy.INumpyArrayWrapper;
import ai.sklearn4j.core.libraries.numpy.NumpyOperationException;

public class NumpyArray<Type> {
    private INumpyArrayWrapper data = null;

    protected NumpyArray(INumpyArrayWrapper data) {
        this.data = data;
    }

    public int[] getShape() {
        return this.data.getShape();
    }

    public Type get(int ... indices) {
        if (indices.length != this.getShape().length) {
            throw new NumpyOperationException("The number of indices provided doesn't match the number of dimensions.");
        }
        return (Type)this.data.get(indices);
    }

    public void applyToEachElement(INumpyArrayElementOperation<Type> operation) {
        int[] shape = this.data.getShape();
        int[] index = new int[shape.length];
        int[] counter = new int[shape.length + 1];
        counter[0] = -1;
        do {
            NumpyArray.addCounter(counter, shape);
            for (int i = 0; i < index.length; ++i) {
                index[i] = counter[i];
            }
            this.data.set(operation.apply(this.data.get(index)), index);
        } while (counter[counter.length - 1] == 0);
    }

    public void applyToEachElementAnsSaveToTarget(NumpyArray target, INumpyArrayElementOperation<Type> operation) {
        int[] shape = this.data.getShape();
        int[] index = new int[shape.length];
        int[] counter = new int[shape.length + 1];
        counter[0] = -1;
        do {
            NumpyArray.addCounter(counter, shape);
            for (int i = 0; i < index.length; ++i) {
                index[i] = counter[i];
            }
            target.set(operation.apply(this.data.get(index)), index);
        } while (counter[counter.length - 1] == 0);
    }

    public static void addCounter(int[] counter, int[] shape) {
        counter[0] = counter[0] + 1;
        for (int i = 0; i < shape.length && counter[i] == shape[i]; ++i) {
            counter[i] = 0;
            int n = i + 1;
            counter[n] = counter[n] + 1;
        }
    }

    public void set(Object value, int ... indices) {
        this.data.set(value, indices);
    }

    public boolean isFloatingPoint() {
        return this.data.isFloatingPoint();
    }

    public int numberOfBytes() {
        return this.data.numberOfBits() / 8;
    }

    public NumpyArray<Type> transpose() {
        return this.data.transpose();
    }

    public boolean isSingleValueArray() {
        int count = 1;
        int[] shape = this.getShape();
        for (int i = 0; i < shape.length; ++i) {
            count *= shape[i];
        }
        return count == 1;
    }

    public Type getSingleValue() {
        int[] shape = this.getShape();
        int[] index = new int[shape.length];
        return (Type)this.data.get(index);
    }

    public NumpyArray<Type> wrapInnerSubsetArray(int ... indices) {
        return this.data.wrapInnerSubsetArray(indices);
    }

    public int numberOfDimensions() {
        return this.getShape().length;
    }

    public INumpyArrayWrapper getWrapper() {
        return this.data;
    }
}

