/*
 * Decompiled with CFR 0.152.
 */
package ai.sklearn4j.core.libraries.numpy;

import ai.sklearn4j.core.libraries.numpy.NumpyArray;
import ai.sklearn4j.core.libraries.numpy.NumpyOperationException;
import ai.sklearn4j.core.libraries.numpy.wrappers.Dim10DoubleNumpyWrapper;
import ai.sklearn4j.core.libraries.numpy.wrappers.Dim10FloatNumpyWrapper;
import ai.sklearn4j.core.libraries.numpy.wrappers.Dim10Int16NumpyWrapper;
import ai.sklearn4j.core.libraries.numpy.wrappers.Dim10Int32NumpyWrapper;
import ai.sklearn4j.core.libraries.numpy.wrappers.Dim10Int64NumpyWrapper;
import ai.sklearn4j.core.libraries.numpy.wrappers.Dim10Int8NumpyWrapper;
import ai.sklearn4j.core.libraries.numpy.wrappers.Dim1DoubleNumpyWrapper;
import ai.sklearn4j.core.libraries.numpy.wrappers.Dim1FloatNumpyWrapper;
import ai.sklearn4j.core.libraries.numpy.wrappers.Dim1Int16NumpyWrapper;
import ai.sklearn4j.core.libraries.numpy.wrappers.Dim1Int32NumpyWrapper;
import ai.sklearn4j.core.libraries.numpy.wrappers.Dim1Int64NumpyWrapper;
import ai.sklearn4j.core.libraries.numpy.wrappers.Dim1Int8NumpyWrapper;
import ai.sklearn4j.core.libraries.numpy.wrappers.Dim2DoubleNumpyWrapper;
import ai.sklearn4j.core.libraries.numpy.wrappers.Dim2FloatNumpyWrapper;
import ai.sklearn4j.core.libraries.numpy.wrappers.Dim2Int16NumpyWrapper;
import ai.sklearn4j.core.libraries.numpy.wrappers.Dim2Int32NumpyWrapper;
import ai.sklearn4j.core.libraries.numpy.wrappers.Dim2Int64NumpyWrapper;
import ai.sklearn4j.core.libraries.numpy.wrappers.Dim2Int8NumpyWrapper;
import ai.sklearn4j.core.libraries.numpy.wrappers.Dim3DoubleNumpyWrapper;
import ai.sklearn4j.core.libraries.numpy.wrappers.Dim3FloatNumpyWrapper;
import ai.sklearn4j.core.libraries.numpy.wrappers.Dim3Int16NumpyWrapper;
import ai.sklearn4j.core.libraries.numpy.wrappers.Dim3Int32NumpyWrapper;
import ai.sklearn4j.core.libraries.numpy.wrappers.Dim3Int64NumpyWrapper;
import ai.sklearn4j.core.libraries.numpy.wrappers.Dim3Int8NumpyWrapper;
import ai.sklearn4j.core.libraries.numpy.wrappers.Dim4DoubleNumpyWrapper;
import ai.sklearn4j.core.libraries.numpy.wrappers.Dim4FloatNumpyWrapper;
import ai.sklearn4j.core.libraries.numpy.wrappers.Dim4Int16NumpyWrapper;
import ai.sklearn4j.core.libraries.numpy.wrappers.Dim4Int32NumpyWrapper;
import ai.sklearn4j.core.libraries.numpy.wrappers.Dim4Int64NumpyWrapper;
import ai.sklearn4j.core.libraries.numpy.wrappers.Dim4Int8NumpyWrapper;
import ai.sklearn4j.core.libraries.numpy.wrappers.Dim5DoubleNumpyWrapper;
import ai.sklearn4j.core.libraries.numpy.wrappers.Dim5FloatNumpyWrapper;
import ai.sklearn4j.core.libraries.numpy.wrappers.Dim5Int16NumpyWrapper;
import ai.sklearn4j.core.libraries.numpy.wrappers.Dim5Int32NumpyWrapper;
import ai.sklearn4j.core.libraries.numpy.wrappers.Dim5Int64NumpyWrapper;
import ai.sklearn4j.core.libraries.numpy.wrappers.Dim5Int8NumpyWrapper;
import ai.sklearn4j.core.libraries.numpy.wrappers.Dim6DoubleNumpyWrapper;
import ai.sklearn4j.core.libraries.numpy.wrappers.Dim6FloatNumpyWrapper;
import ai.sklearn4j.core.libraries.numpy.wrappers.Dim6Int16NumpyWrapper;
import ai.sklearn4j.core.libraries.numpy.wrappers.Dim6Int32NumpyWrapper;
import ai.sklearn4j.core.libraries.numpy.wrappers.Dim6Int64NumpyWrapper;
import ai.sklearn4j.core.libraries.numpy.wrappers.Dim6Int8NumpyWrapper;
import ai.sklearn4j.core.libraries.numpy.wrappers.Dim7DoubleNumpyWrapper;
import ai.sklearn4j.core.libraries.numpy.wrappers.Dim7FloatNumpyWrapper;
import ai.sklearn4j.core.libraries.numpy.wrappers.Dim7Int16NumpyWrapper;
import ai.sklearn4j.core.libraries.numpy.wrappers.Dim7Int32NumpyWrapper;
import ai.sklearn4j.core.libraries.numpy.wrappers.Dim7Int64NumpyWrapper;
import ai.sklearn4j.core.libraries.numpy.wrappers.Dim7Int8NumpyWrapper;
import ai.sklearn4j.core.libraries.numpy.wrappers.Dim8DoubleNumpyWrapper;
import ai.sklearn4j.core.libraries.numpy.wrappers.Dim8FloatNumpyWrapper;
import ai.sklearn4j.core.libraries.numpy.wrappers.Dim8Int16NumpyWrapper;
import ai.sklearn4j.core.libraries.numpy.wrappers.Dim8Int32NumpyWrapper;
import ai.sklearn4j.core.libraries.numpy.wrappers.Dim8Int64NumpyWrapper;
import ai.sklearn4j.core.libraries.numpy.wrappers.Dim8Int8NumpyWrapper;
import ai.sklearn4j.core.libraries.numpy.wrappers.Dim9DoubleNumpyWrapper;
import ai.sklearn4j.core.libraries.numpy.wrappers.Dim9FloatNumpyWrapper;
import ai.sklearn4j.core.libraries.numpy.wrappers.Dim9Int16NumpyWrapper;
import ai.sklearn4j.core.libraries.numpy.wrappers.Dim9Int32NumpyWrapper;
import ai.sklearn4j.core.libraries.numpy.wrappers.Dim9Int64NumpyWrapper;
import ai.sklearn4j.core.libraries.numpy.wrappers.Dim9Int8NumpyWrapper;

public class NumpyArrayFactory {
    public static final int SIZE_OF_INT_8 = 1;
    public static final int SIZE_OF_INT_16 = 2;
    public static final int SIZE_OF_INT_32 = 4;
    public static final int SIZE_OF_INT_64 = 8;
    public static final int SIZE_OF_FLOAT = 4;
    public static final int SIZE_OF_DOUBLE = 8;

    public static NumpyArray createArrayOfShapeAndTypeInfo(NumpyArray other) {
        return NumpyArrayFactory.createArrayOfShapeAndTypeInfo(other.isFloatingPoint(), other.numberOfBytes(), other.getShape());
    }

    public static NumpyArray createArrayOfShapeAndTypeInfo(boolean isFloatingPoint, int size, int[] shape) {
        NumpyArray<Number> result = null;
        if (isFloatingPoint) {
            result = size == 8 ? NumpyArrayFactory.arrayOfDoubleWithShape(shape) : NumpyArrayFactory.arrayOfFloatWithShape(shape);
        } else if (size == 8) {
            result = NumpyArrayFactory.arrayOfInt64WithShape(shape);
        } else if (size == 4) {
            result = NumpyArrayFactory.arrayOfInt32WithShape(shape);
        } else if (size == 2) {
            result = NumpyArrayFactory.arrayOfInt16WithShape(shape);
        } else if (size == 1) {
            result = NumpyArrayFactory.arrayOfInt8WithShape(shape);
        }
        return result;
    }

    public static byte toByte(Object o) {
        byte result = 0;
        if (o instanceof Byte) {
            result = (Byte)o;
        } else if (o instanceof Short) {
            result = (byte)((Short)o).shortValue();
        } else if (o instanceof Integer) {
            result = (byte)((Integer)o).intValue();
        } else if (o instanceof Long) {
            result = (byte)((Long)o).longValue();
        } else {
            throw new NumpyOperationException("Invalid casting value to byte.");
        }
        return result;
    }

    public static double toDouble(Object value) {
        return (Double)value;
    }

    public static float toFloat(Object value) {
        return ((Float)value).floatValue();
    }

    public static short toShort(Object o) {
        short result = 0;
        if (o instanceof Byte) {
            result = (Short)o;
        } else if (o instanceof Short) {
            result = (Short)o;
        } else if (o instanceof Integer) {
            result = (short)((Integer)o).intValue();
        } else if (o instanceof Long) {
            result = (short)((Long)o).longValue();
        } else {
            throw new NumpyOperationException("Invalid casting value to short.");
        }
        return result;
    }

    public static int toInteger(Object o) {
        int result = 0;
        if (o instanceof Byte) {
            result = (Integer)o;
        } else if (o instanceof Short) {
            result = ((Short)o).shortValue();
        } else if (o instanceof Integer) {
            result = (Integer)o;
        } else if (o instanceof Long) {
            result = (int)((Long)o).longValue();
        } else {
            throw new NumpyOperationException("Invalid casting value to int.");
        }
        return result;
    }

    public static long toLong(Object o) {
        long result = 0L;
        if (o instanceof Byte) {
            result = (Long)o;
        } else if (o instanceof Short) {
            result = ((Short)o).shortValue();
        } else if (o instanceof Integer) {
            result = ((Integer)o).intValue();
        } else if (o instanceof Long) {
            result = (Long)o;
        } else {
            throw new NumpyOperationException("Invalid casting value to long.");
        }
        return result;
    }

    public static NumpyArray<Byte> from(byte[] array) {
        return new NumpyArray<Byte>(new Dim1Int8NumpyWrapper(array));
    }

    public static NumpyArray<Byte> from(byte[][] array) {
        return new NumpyArray<Byte>(new Dim2Int8NumpyWrapper(array));
    }

    public static NumpyArray<Byte> from(byte[][][] array) {
        return new NumpyArray<Byte>(new Dim3Int8NumpyWrapper(array));
    }

    public static NumpyArray<Byte> from(byte[][][][] array) {
        return new NumpyArray<Byte>(new Dim4Int8NumpyWrapper(array));
    }

    public static NumpyArray<Byte> from(byte[][][][][] array) {
        return new NumpyArray<Byte>(new Dim5Int8NumpyWrapper(array));
    }

    public static NumpyArray<Byte> from(byte[][][][][][] array) {
        return new NumpyArray<Byte>(new Dim6Int8NumpyWrapper(array));
    }

    public static NumpyArray<Byte> from(byte[][][][][][][] array) {
        return new NumpyArray<Byte>(new Dim7Int8NumpyWrapper(array));
    }

    public static NumpyArray<Byte> from(byte[][][][][][][][] array) {
        return new NumpyArray<Byte>(new Dim8Int8NumpyWrapper(array));
    }

    public static NumpyArray<Byte> from(byte[][][][][][][][][] array) {
        return new NumpyArray<Byte>(new Dim9Int8NumpyWrapper(array));
    }

    public static NumpyArray<Byte> from(byte[][][][][][][][][][] array) {
        return new NumpyArray<Byte>(new Dim10Int8NumpyWrapper(array));
    }

    public static NumpyArray<Short> from(short[] array) {
        return new NumpyArray<Short>(new Dim1Int16NumpyWrapper(array));
    }

    public static NumpyArray<Short> from(short[][] array) {
        return new NumpyArray<Short>(new Dim2Int16NumpyWrapper(array));
    }

    public static NumpyArray<Short> from(short[][][] array) {
        return new NumpyArray<Short>(new Dim3Int16NumpyWrapper(array));
    }

    public static NumpyArray<Short> from(short[][][][] array) {
        return new NumpyArray<Short>(new Dim4Int16NumpyWrapper(array));
    }

    public static NumpyArray<Short> from(short[][][][][] array) {
        return new NumpyArray<Short>(new Dim5Int16NumpyWrapper(array));
    }

    public static NumpyArray<Short> from(short[][][][][][] array) {
        return new NumpyArray<Short>(new Dim6Int16NumpyWrapper(array));
    }

    public static NumpyArray<Short> from(short[][][][][][][] array) {
        return new NumpyArray<Short>(new Dim7Int16NumpyWrapper(array));
    }

    public static NumpyArray<Short> from(short[][][][][][][][] array) {
        return new NumpyArray<Short>(new Dim8Int16NumpyWrapper(array));
    }

    public static NumpyArray<Short> from(short[][][][][][][][][] array) {
        return new NumpyArray<Short>(new Dim9Int16NumpyWrapper(array));
    }

    public static NumpyArray<Short> from(short[][][][][][][][][][] array) {
        return new NumpyArray<Short>(new Dim10Int16NumpyWrapper(array));
    }

    public static NumpyArray<Integer> from(int[] array) {
        return new NumpyArray<Integer>(new Dim1Int32NumpyWrapper(array));
    }

    public static NumpyArray<Integer> from(int[][] array) {
        return new NumpyArray<Integer>(new Dim2Int32NumpyWrapper(array));
    }

    public static NumpyArray<Integer> from(int[][][] array) {
        return new NumpyArray<Integer>(new Dim3Int32NumpyWrapper(array));
    }

    public static NumpyArray<Integer> from(int[][][][] array) {
        return new NumpyArray<Integer>(new Dim4Int32NumpyWrapper(array));
    }

    public static NumpyArray<Integer> from(int[][][][][] array) {
        return new NumpyArray<Integer>(new Dim5Int32NumpyWrapper(array));
    }

    public static NumpyArray<Integer> from(int[][][][][][] array) {
        return new NumpyArray<Integer>(new Dim6Int32NumpyWrapper(array));
    }

    public static NumpyArray<Integer> from(int[][][][][][][] array) {
        return new NumpyArray<Integer>(new Dim7Int32NumpyWrapper(array));
    }

    public static NumpyArray<Integer> from(int[][][][][][][][] array) {
        return new NumpyArray<Integer>(new Dim8Int32NumpyWrapper(array));
    }

    public static NumpyArray<Integer> from(int[][][][][][][][][] array) {
        return new NumpyArray<Integer>(new Dim9Int32NumpyWrapper(array));
    }

    public static NumpyArray<Integer> from(int[][][][][][][][][][] array) {
        return new NumpyArray<Integer>(new Dim10Int32NumpyWrapper(array));
    }

    public static NumpyArray<Long> from(long[] array) {
        return new NumpyArray<Long>(new Dim1Int64NumpyWrapper(array));
    }

    public static NumpyArray<Long> from(long[][] array) {
        return new NumpyArray<Long>(new Dim2Int64NumpyWrapper(array));
    }

    public static NumpyArray<Long> from(long[][][] array) {
        return new NumpyArray<Long>(new Dim3Int64NumpyWrapper(array));
    }

    public static NumpyArray<Long> from(long[][][][] array) {
        return new NumpyArray<Long>(new Dim4Int64NumpyWrapper(array));
    }

    public static NumpyArray<Long> from(long[][][][][] array) {
        return new NumpyArray<Long>(new Dim5Int64NumpyWrapper(array));
    }

    public static NumpyArray<Long> from(long[][][][][][] array) {
        return new NumpyArray<Long>(new Dim6Int64NumpyWrapper(array));
    }

    public static NumpyArray<Long> from(long[][][][][][][] array) {
        return new NumpyArray<Long>(new Dim7Int64NumpyWrapper(array));
    }

    public static NumpyArray<Long> from(long[][][][][][][][] array) {
        return new NumpyArray<Long>(new Dim8Int64NumpyWrapper(array));
    }

    public static NumpyArray<Long> from(long[][][][][][][][][] array) {
        return new NumpyArray<Long>(new Dim9Int64NumpyWrapper(array));
    }

    public static NumpyArray<Long> from(long[][][][][][][][][][] array) {
        return new NumpyArray<Long>(new Dim10Int64NumpyWrapper(array));
    }

    public static NumpyArray<Float> from(float[] array) {
        return new NumpyArray<Float>(new Dim1FloatNumpyWrapper(array));
    }

    public static NumpyArray<Float> from(float[][] array) {
        return new NumpyArray<Float>(new Dim2FloatNumpyWrapper(array));
    }

    public static NumpyArray<Float> from(float[][][] array) {
        return new NumpyArray<Float>(new Dim3FloatNumpyWrapper(array));
    }

    public static NumpyArray<Float> from(float[][][][] array) {
        return new NumpyArray<Float>(new Dim4FloatNumpyWrapper(array));
    }

    public static NumpyArray<Float> from(float[][][][][] array) {
        return new NumpyArray<Float>(new Dim5FloatNumpyWrapper(array));
    }

    public static NumpyArray<Float> from(float[][][][][][] array) {
        return new NumpyArray<Float>(new Dim6FloatNumpyWrapper(array));
    }

    public static NumpyArray<Float> from(float[][][][][][][] array) {
        return new NumpyArray<Float>(new Dim7FloatNumpyWrapper(array));
    }

    public static NumpyArray<Float> from(float[][][][][][][][] array) {
        return new NumpyArray<Float>(new Dim8FloatNumpyWrapper(array));
    }

    public static NumpyArray<Float> from(float[][][][][][][][][] array) {
        return new NumpyArray<Float>(new Dim9FloatNumpyWrapper(array));
    }

    public static NumpyArray<Float> from(float[][][][][][][][][][] array) {
        return new NumpyArray<Float>(new Dim10FloatNumpyWrapper(array));
    }

    public static NumpyArray<Double> from(double[] array) {
        return new NumpyArray<Double>(new Dim1DoubleNumpyWrapper(array));
    }

    public static NumpyArray<Double> from(double[][] array) {
        return new NumpyArray<Double>(new Dim2DoubleNumpyWrapper(array));
    }

    public static NumpyArray<Double> from(double[][][] array) {
        return new NumpyArray<Double>(new Dim3DoubleNumpyWrapper(array));
    }

    public static NumpyArray<Double> from(double[][][][] array) {
        return new NumpyArray<Double>(new Dim4DoubleNumpyWrapper(array));
    }

    public static NumpyArray<Double> from(double[][][][][] array) {
        return new NumpyArray<Double>(new Dim5DoubleNumpyWrapper(array));
    }

    public static NumpyArray<Double> from(double[][][][][][] array) {
        return new NumpyArray<Double>(new Dim6DoubleNumpyWrapper(array));
    }

    public static NumpyArray<Double> from(double[][][][][][][] array) {
        return new NumpyArray<Double>(new Dim7DoubleNumpyWrapper(array));
    }

    public static NumpyArray<Double> from(double[][][][][][][][] array) {
        return new NumpyArray<Double>(new Dim8DoubleNumpyWrapper(array));
    }

    public static NumpyArray<Double> from(double[][][][][][][][][] array) {
        return new NumpyArray<Double>(new Dim9DoubleNumpyWrapper(array));
    }

    public static NumpyArray<Double> from(double[][][][][][][][][][] array) {
        return new NumpyArray<Double>(new Dim10DoubleNumpyWrapper(array));
    }

    public static NumpyArray<Byte> arrayOfInt8WithShape(int[] shape) {
        if (shape.length == 1) {
            return NumpyArrayFactory.from(new byte[shape[0]]);
        }
        if (shape.length == 2) {
            return NumpyArrayFactory.from(new byte[shape[0]][shape[1]]);
        }
        if (shape.length == 3) {
            return NumpyArrayFactory.from(new byte[shape[0]][shape[1]][shape[2]]);
        }
        if (shape.length == 4) {
            return NumpyArrayFactory.from(new byte[shape[0]][shape[1]][shape[2]][shape[3]]);
        }
        if (shape.length == 5) {
            return NumpyArrayFactory.from(new byte[shape[0]][shape[1]][shape[2]][shape[3]][shape[4]]);
        }
        if (shape.length == 6) {
            return NumpyArrayFactory.from(new byte[shape[0]][shape[1]][shape[2]][shape[3]][shape[4]][shape[5]]);
        }
        if (shape.length == 7) {
            return NumpyArrayFactory.from(new byte[shape[0]][shape[1]][shape[2]][shape[3]][shape[4]][shape[5]][shape[6]]);
        }
        if (shape.length == 8) {
            return NumpyArrayFactory.from(new byte[shape[0]][shape[1]][shape[2]][shape[3]][shape[4]][shape[5]][shape[6]][shape[7]]);
        }
        if (shape.length == 9) {
            return NumpyArrayFactory.from(new byte[shape[0]][shape[1]][shape[2]][shape[3]][shape[4]][shape[5]][shape[6]][shape[7]][shape[8]]);
        }
        if (shape.length == 10) {
            return NumpyArrayFactory.from(new byte[shape[0]][shape[1]][shape[2]][shape[3]][shape[4]][shape[5]][shape[6]][shape[7]][shape[8]][shape[9]]);
        }
        throw new NumpyOperationException("The shape specified is not supported; only arrays less than 10 dimensions are supported.");
    }

    public static NumpyArray<Short> arrayOfInt16WithShape(int[] shape) {
        if (shape.length == 1) {
            return NumpyArrayFactory.from(new short[shape[0]]);
        }
        if (shape.length == 2) {
            return NumpyArrayFactory.from(new short[shape[0]][shape[1]]);
        }
        if (shape.length == 3) {
            return NumpyArrayFactory.from(new short[shape[0]][shape[1]][shape[2]]);
        }
        if (shape.length == 4) {
            return NumpyArrayFactory.from(new short[shape[0]][shape[1]][shape[2]][shape[3]]);
        }
        if (shape.length == 5) {
            return NumpyArrayFactory.from(new short[shape[0]][shape[1]][shape[2]][shape[3]][shape[4]]);
        }
        if (shape.length == 6) {
            return NumpyArrayFactory.from(new short[shape[0]][shape[1]][shape[2]][shape[3]][shape[4]][shape[5]]);
        }
        if (shape.length == 7) {
            return NumpyArrayFactory.from(new short[shape[0]][shape[1]][shape[2]][shape[3]][shape[4]][shape[5]][shape[6]]);
        }
        if (shape.length == 8) {
            return NumpyArrayFactory.from(new short[shape[0]][shape[1]][shape[2]][shape[3]][shape[4]][shape[5]][shape[6]][shape[7]]);
        }
        if (shape.length == 9) {
            return NumpyArrayFactory.from(new short[shape[0]][shape[1]][shape[2]][shape[3]][shape[4]][shape[5]][shape[6]][shape[7]][shape[8]]);
        }
        if (shape.length == 10) {
            return NumpyArrayFactory.from(new short[shape[0]][shape[1]][shape[2]][shape[3]][shape[4]][shape[5]][shape[6]][shape[7]][shape[8]][shape[9]]);
        }
        throw new NumpyOperationException("The shape specified is not supported; only arrays less than 10 dimensions are supported.");
    }

    public static NumpyArray<Integer> arrayOfInt32WithShape(int[] shape) {
        if (shape.length == 1) {
            return NumpyArrayFactory.from(new int[shape[0]]);
        }
        if (shape.length == 2) {
            return NumpyArrayFactory.from(new int[shape[0]][shape[1]]);
        }
        if (shape.length == 3) {
            return NumpyArrayFactory.from(new int[shape[0]][shape[1]][shape[2]]);
        }
        if (shape.length == 4) {
            return NumpyArrayFactory.from(new int[shape[0]][shape[1]][shape[2]][shape[3]]);
        }
        if (shape.length == 5) {
            return NumpyArrayFactory.from(new int[shape[0]][shape[1]][shape[2]][shape[3]][shape[4]]);
        }
        if (shape.length == 6) {
            return NumpyArrayFactory.from(new int[shape[0]][shape[1]][shape[2]][shape[3]][shape[4]][shape[5]]);
        }
        if (shape.length == 7) {
            return NumpyArrayFactory.from(new int[shape[0]][shape[1]][shape[2]][shape[3]][shape[4]][shape[5]][shape[6]]);
        }
        if (shape.length == 8) {
            return NumpyArrayFactory.from(new int[shape[0]][shape[1]][shape[2]][shape[3]][shape[4]][shape[5]][shape[6]][shape[7]]);
        }
        if (shape.length == 9) {
            return NumpyArrayFactory.from(new int[shape[0]][shape[1]][shape[2]][shape[3]][shape[4]][shape[5]][shape[6]][shape[7]][shape[8]]);
        }
        if (shape.length == 10) {
            return NumpyArrayFactory.from(new int[shape[0]][shape[1]][shape[2]][shape[3]][shape[4]][shape[5]][shape[6]][shape[7]][shape[8]][shape[9]]);
        }
        throw new NumpyOperationException("The shape specified is not supported; only arrays less than 10 dimensions are supported.");
    }

    public static NumpyArray<Long> arrayOfInt64WithShape(int[] shape) {
        if (shape.length == 1) {
            return NumpyArrayFactory.from(new long[shape[0]]);
        }
        if (shape.length == 2) {
            return NumpyArrayFactory.from(new long[shape[0]][shape[1]]);
        }
        if (shape.length == 3) {
            return NumpyArrayFactory.from(new long[shape[0]][shape[1]][shape[2]]);
        }
        if (shape.length == 4) {
            return NumpyArrayFactory.from(new long[shape[0]][shape[1]][shape[2]][shape[3]]);
        }
        if (shape.length == 5) {
            return NumpyArrayFactory.from(new long[shape[0]][shape[1]][shape[2]][shape[3]][shape[4]]);
        }
        if (shape.length == 6) {
            return NumpyArrayFactory.from(new long[shape[0]][shape[1]][shape[2]][shape[3]][shape[4]][shape[5]]);
        }
        if (shape.length == 7) {
            return NumpyArrayFactory.from(new long[shape[0]][shape[1]][shape[2]][shape[3]][shape[4]][shape[5]][shape[6]]);
        }
        if (shape.length == 8) {
            return NumpyArrayFactory.from(new long[shape[0]][shape[1]][shape[2]][shape[3]][shape[4]][shape[5]][shape[6]][shape[7]]);
        }
        if (shape.length == 9) {
            return NumpyArrayFactory.from(new long[shape[0]][shape[1]][shape[2]][shape[3]][shape[4]][shape[5]][shape[6]][shape[7]][shape[8]]);
        }
        if (shape.length == 10) {
            return NumpyArrayFactory.from(new long[shape[0]][shape[1]][shape[2]][shape[3]][shape[4]][shape[5]][shape[6]][shape[7]][shape[8]][shape[9]]);
        }
        throw new NumpyOperationException("The shape specified is not supported; only arrays less than 10 dimensions are supported.");
    }

    public static NumpyArray<Float> arrayOfFloatWithShape(int[] shape) {
        if (shape.length == 1) {
            return NumpyArrayFactory.from(new float[shape[0]]);
        }
        if (shape.length == 2) {
            return NumpyArrayFactory.from(new float[shape[0]][shape[1]]);
        }
        if (shape.length == 3) {
            return NumpyArrayFactory.from(new float[shape[0]][shape[1]][shape[2]]);
        }
        if (shape.length == 4) {
            return NumpyArrayFactory.from(new float[shape[0]][shape[1]][shape[2]][shape[3]]);
        }
        if (shape.length == 5) {
            return NumpyArrayFactory.from(new float[shape[0]][shape[1]][shape[2]][shape[3]][shape[4]]);
        }
        if (shape.length == 6) {
            return NumpyArrayFactory.from(new float[shape[0]][shape[1]][shape[2]][shape[3]][shape[4]][shape[5]]);
        }
        if (shape.length == 7) {
            return NumpyArrayFactory.from(new float[shape[0]][shape[1]][shape[2]][shape[3]][shape[4]][shape[5]][shape[6]]);
        }
        if (shape.length == 8) {
            return NumpyArrayFactory.from(new float[shape[0]][shape[1]][shape[2]][shape[3]][shape[4]][shape[5]][shape[6]][shape[7]]);
        }
        if (shape.length == 9) {
            return NumpyArrayFactory.from(new float[shape[0]][shape[1]][shape[2]][shape[3]][shape[4]][shape[5]][shape[6]][shape[7]][shape[8]]);
        }
        if (shape.length == 10) {
            return NumpyArrayFactory.from(new float[shape[0]][shape[1]][shape[2]][shape[3]][shape[4]][shape[5]][shape[6]][shape[7]][shape[8]][shape[9]]);
        }
        throw new NumpyOperationException("The shape specified is not supported; only arrays less than 10 dimensions are supported.");
    }

    public static NumpyArray<Double> arrayOfDoubleWithShape(int[] shape) {
        if (shape.length == 1) {
            return NumpyArrayFactory.from(new double[shape[0]]);
        }
        if (shape.length == 2) {
            return NumpyArrayFactory.from(new double[shape[0]][shape[1]]);
        }
        if (shape.length == 3) {
            return NumpyArrayFactory.from(new double[shape[0]][shape[1]][shape[2]]);
        }
        if (shape.length == 4) {
            return NumpyArrayFactory.from(new double[shape[0]][shape[1]][shape[2]][shape[3]]);
        }
        if (shape.length == 5) {
            return NumpyArrayFactory.from(new double[shape[0]][shape[1]][shape[2]][shape[3]][shape[4]]);
        }
        if (shape.length == 6) {
            return NumpyArrayFactory.from(new double[shape[0]][shape[1]][shape[2]][shape[3]][shape[4]][shape[5]]);
        }
        if (shape.length == 7) {
            return NumpyArrayFactory.from(new double[shape[0]][shape[1]][shape[2]][shape[3]][shape[4]][shape[5]][shape[6]]);
        }
        if (shape.length == 8) {
            return NumpyArrayFactory.from(new double[shape[0]][shape[1]][shape[2]][shape[3]][shape[4]][shape[5]][shape[6]][shape[7]]);
        }
        if (shape.length == 9) {
            return NumpyArrayFactory.from(new double[shape[0]][shape[1]][shape[2]][shape[3]][shape[4]][shape[5]][shape[6]][shape[7]][shape[8]]);
        }
        if (shape.length == 10) {
            return NumpyArrayFactory.from(new double[shape[0]][shape[1]][shape[2]][shape[3]][shape[4]][shape[5]][shape[6]][shape[7]][shape[8]][shape[9]]);
        }
        throw new NumpyOperationException("The shape specified is not supported; only arrays less than 10 dimensions are supported.");
    }
}

