/*
 * Decompiled with CFR 0.152.
 */
package ai.sklearn4j.core.libraries.numpy.wrappers;

import ai.sklearn4j.core.libraries.numpy.INumpyArrayWrapper;
import ai.sklearn4j.core.libraries.numpy.NumpyArray;
import ai.sklearn4j.core.libraries.numpy.NumpyArrayFactory;
import ai.sklearn4j.core.libraries.numpy.NumpyOperationException;

public class Dim1DoubleNumpyWrapper
implements INumpyArrayWrapper {
    private final double[] array;
    private final int[] shape;

    public Dim1DoubleNumpyWrapper(double[] array) {
        this.array = array;
        this.shape = new int[]{array.length};
    }

    @Override
    public int[] getShape() {
        return this.shape;
    }

    @Override
    public Object get(int ... indices) {
        return this.array[indices[0]];
    }

    @Override
    public void set(Object value, int ... indices) {
        this.array[indices[0]] = NumpyArrayFactory.toDouble(value);
    }

    public double[] getArray() {
        return this.array;
    }

    @Override
    public boolean isFloatingPoint() {
        return true;
    }

    @Override
    public int numberOfBits() {
        return 64;
    }

    @Override
    public Object getRawArray() {
        return this.array;
    }

    @Override
    public NumpyArray wrapInnerSubsetArray(int ... indices) {
        throw new NumpyOperationException("A single dimension sub array can't be sliced.");
    }

    @Override
    public NumpyArray transpose() {
        double[] result = new double[this.shape[0]];
        for (int d0 = 0; d0 < this.shape[0]; ++d0) {
            result[d0] = this.array[d0];
        }
        return NumpyArrayFactory.from(result);
    }
}

