/*
 * Decompiled with CFR 0.152.
 */
package ai.sklearn4j.core.libraries.numpy.wrappers;

import ai.sklearn4j.core.libraries.numpy.INumpyArrayWrapper;
import ai.sklearn4j.core.libraries.numpy.NumpyArray;
import ai.sklearn4j.core.libraries.numpy.NumpyArrayFactory;
import ai.sklearn4j.core.libraries.numpy.NumpyOperationException;

public class Dim2Int8NumpyWrapper
implements INumpyArrayWrapper {
    private final byte[][] array;
    private final int[] shape;

    public Dim2Int8NumpyWrapper(byte[][] array) {
        this.array = array;
        this.shape = new int[]{array.length, array[0].length};
    }

    @Override
    public int[] getShape() {
        return this.shape;
    }

    @Override
    public Object get(int ... indices) {
        return this.array[indices[0]][indices[1]];
    }

    @Override
    public void set(Object value, int ... indices) {
        this.array[indices[0]][indices[1]] = NumpyArrayFactory.toByte(value);
    }

    public byte[][] getArray() {
        return this.array;
    }

    @Override
    public boolean isFloatingPoint() {
        return false;
    }

    @Override
    public int numberOfBits() {
        return 8;
    }

    @Override
    public Object getRawArray() {
        return this.array;
    }

    @Override
    public NumpyArray wrapInnerSubsetArray(int ... indices) {
        NumpyArray<Byte> result = null;
        if (indices.length != 1) {
            throw new NumpyOperationException("Invalid slice for array specified.");
        }
        result = NumpyArrayFactory.from(this.array[indices[0]]);
        return result;
    }

    @Override
    public NumpyArray transpose() {
        byte[][] result = new byte[this.shape[1]][this.shape[0]];
        for (int d0 = 0; d0 < this.shape[0]; ++d0) {
            for (int d1 = 0; d1 < this.shape[1]; ++d1) {
                result[d1][d0] = this.array[d0][d1];
            }
        }
        return NumpyArrayFactory.from(result);
    }
}

