/*
 * Decompiled with CFR 0.152.
 */
package ai.sklearn4j.core.packaging;

import ai.sklearn4j.core.ScikitLearnCoreException;
import ai.sklearn4j.core.packaging.BinaryModelPackage;
import ai.sklearn4j.core.packaging.IScikitLearnPackage;
import ai.sklearn4j.core.packaging.version_1.ScikitLearnPackageV1;
import java.io.FileInputStream;

public class ScikitLearnPackageFactory {
    public static IScikitLearnPackage loadFromFile(String path) {
        int version = ScikitLearnPackageFactory.readFileVersion(path);
        ScikitLearnPackageV1 pkg = null;
        if (version != 1) {
            throw new ScikitLearnCoreException("This version of the file format is not supported.");
        }
        pkg = new ScikitLearnPackageV1();
        pkg.loadFromFile(path);
        return pkg;
    }

    private static int readFileVersion(String path) {
        try {
            FileInputStream fs = new FileInputStream(path);
            BinaryModelPackage buffer = BinaryModelPackage.fromStream(fs);
            int result = buffer.readInteger();
            fs.close();
            return result;
        }
        catch (Exception ex) {
            throw new ScikitLearnCoreException("An error occurred while determining the version of binary package file." + ex.getMessage());
        }
    }
}

