/*
 * Decompiled with CFR 0.152.
 */
package ai.sklearn4j.core.packaging.loaders;

import ai.sklearn4j.base.ClassifierMixin;
import ai.sklearn4j.core.ScikitLearnCoreException;
import ai.sklearn4j.core.libraries.numpy.NumpyArray;
import ai.sklearn4j.core.packaging.BinaryModelPackage;
import ai.sklearn4j.core.packaging.loaders.IScikitLearnContentLoader;
import ai.sklearn4j.core.packaging.loaders.IScikitLearnLoaderDoubleFieldSetter;
import ai.sklearn4j.core.packaging.loaders.IScikitLearnLoaderListOfNumpyArrayFieldSetter;
import ai.sklearn4j.core.packaging.loaders.IScikitLearnLoaderLongFieldSetter;
import ai.sklearn4j.core.packaging.loaders.IScikitLearnLoaderNumpyArrayFieldSetter;
import ai.sklearn4j.core.packaging.loaders.IScikitLearnLoaderStringArrayFieldSetter;
import ai.sklearn4j.core.packaging.loaders.LoaderFieldInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class BaseScikitLearnContentLoader<ObjectType>
implements IScikitLearnContentLoader {
    private final String typeName;
    private final Map<String, LoaderFieldInfo> fields = new HashMap<String, LoaderFieldInfo>();

    protected BaseScikitLearnContentLoader(String typeName) {
        this.typeName = typeName;
        this.registerSetters();
        if (this.createResultObject() instanceof ClassifierMixin) {
            this.registerLongField("n_features", this::setNumberOfFeatureIn);
            this.registerStringArrayField("feature_names", this::setFeaturesIn);
        }
    }

    protected abstract ObjectType createResultObject();

    protected abstract void registerSetters();

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public Object loadContent(BinaryModelPackage buffer) {
        ObjectType result = this.createResultObject();
        int fieldCount = buffer.readInteger();
        for (int i = 0; i < fieldCount; ++i) {
            String name = buffer.readString();
            if (!this.fields.containsKey(name)) {
                throw new ScikitLearnCoreException("Package contains an unregistered field name: " + name);
            }
            LoaderFieldInfo info = this.fields.get(name);
            if (info.fieldType == 1) {
                double value = buffer.readDouble();
                ((IScikitLearnLoaderDoubleFieldSetter)info.setter).setDoubleField(result, value);
                continue;
            }
            if (info.fieldType == 2) {
                long value = buffer.readLongInteger();
                ((IScikitLearnLoaderLongFieldSetter)info.setter).setLongField(result, value);
                continue;
            }
            if (info.fieldType == 3) {
                NumpyArray value = buffer.readNumpyArray();
                ((IScikitLearnLoaderNumpyArrayFieldSetter)info.setter).setNumpyArrayField(result, value);
                continue;
            }
            if (info.fieldType == 4) {
                String[] value = buffer.readStringArray();
                ((IScikitLearnLoaderStringArrayFieldSetter)info.setter).setStringArrayField(result, value);
                continue;
            }
            if (info.fieldType != 5) continue;
            List<Object> value = buffer.readList();
            ArrayList finalValue = new ArrayList();
            for (Object o : value) {
                finalValue.add((NumpyArray)o);
            }
            ((IScikitLearnLoaderListOfNumpyArrayFieldSetter)info.setter).setListOfNumpyArrayField(result, finalValue);
        }
        return result;
    }

    protected void registerDoubleField(String name, IScikitLearnLoaderDoubleFieldSetter<ObjectType> setter) {
        if (this.fields.containsKey(name)) {
            throw new ScikitLearnCoreException("Field is already added");
        }
        LoaderFieldInfo field = new LoaderFieldInfo();
        field.name = name;
        field.setter = setter;
        field.fieldType = 1;
        this.fields.put(name, field);
    }

    protected void registerLongField(String name, IScikitLearnLoaderLongFieldSetter<ObjectType> setter) {
        if (this.fields.containsKey(name)) {
            throw new ScikitLearnCoreException("Field is already added");
        }
        LoaderFieldInfo field = new LoaderFieldInfo();
        field.name = name;
        field.setter = setter;
        field.fieldType = 2;
        this.fields.put(name, field);
    }

    protected void registerNumpyArrayField(String name, IScikitLearnLoaderNumpyArrayFieldSetter<ObjectType> setter) {
        if (this.fields.containsKey(name)) {
            throw new ScikitLearnCoreException("Field is already added");
        }
        LoaderFieldInfo field = new LoaderFieldInfo();
        field.name = name;
        field.setter = setter;
        field.fieldType = 3;
        this.fields.put(name, field);
    }

    protected void registerStringArrayField(String name, IScikitLearnLoaderStringArrayFieldSetter<ObjectType> setter) {
        if (this.fields.containsKey(name)) {
            throw new ScikitLearnCoreException("Field is already added");
        }
        LoaderFieldInfo field = new LoaderFieldInfo();
        field.name = name;
        field.setter = setter;
        field.fieldType = 4;
        this.fields.put(name, field);
    }

    protected <ArrayType> void registerListOfNumpyArrayField(String name, IScikitLearnLoaderListOfNumpyArrayFieldSetter<ObjectType, ArrayType> setter) {
        if (this.fields.containsKey(name)) {
            throw new ScikitLearnCoreException("Field is already added");
        }
        LoaderFieldInfo field = new LoaderFieldInfo();
        field.name = name;
        field.setter = setter;
        field.fieldType = 5;
        this.fields.put(name, field);
    }

    private void setFeaturesIn(ObjectType result, String[] value) {
        if (result instanceof ClassifierMixin) {
            ((ClassifierMixin)result).setFeatureNamesIn(value);
        }
    }

    private void setNumberOfFeatureIn(ObjectType result, long value) {
        if (result instanceof ClassifierMixin) {
            ((ClassifierMixin)result).setNumberOfFeatures((int)value);
        }
    }
}

