/*
 * Decompiled with CFR 0.152.
 */
package ai.sklearn4j.core.packaging.loaders;

import ai.sklearn4j.core.ScikitLearnCoreException;
import ai.sklearn4j.core.packaging.loaders.IScikitLearnContentLoader;
import ai.sklearn4j.core.packaging.loaders.classifiers.naive_bayes.BernoulliNaiveBayesContentLoader;
import ai.sklearn4j.core.packaging.loaders.classifiers.naive_bayes.CategoricalNaiveBayesContentLoader;
import ai.sklearn4j.core.packaging.loaders.classifiers.naive_bayes.ComplementNaiveBayesContentLoader;
import ai.sklearn4j.core.packaging.loaders.classifiers.naive_bayes.GaussianNaiveBayesContentLoader;
import ai.sklearn4j.core.packaging.loaders.classifiers.naive_bayes.MultinomialNaiveBayesContentLoader;
import java.util.HashMap;
import java.util.Map;

public class ScikitLearnContentLoaderFactory {
    private static Map<String, IScikitLearnContentLoader> registeredLoaders = null;

    private static void registerLoader(IScikitLearnContentLoader loader) {
        registeredLoaders.put(loader.getTypeName(), loader);
    }

    public static IScikitLearnContentLoader loaderForType(String type) {
        if (registeredLoaders.containsKey(type)) {
            return registeredLoaders.get(type);
        }
        throw new ScikitLearnCoreException(String.format("The loader type '%s' is not supported.", type));
    }

    static {
        registeredLoaders = new HashMap<String, IScikitLearnContentLoader>();
        ScikitLearnContentLoaderFactory.registerLoader(new GaussianNaiveBayesContentLoader());
        ScikitLearnContentLoaderFactory.registerLoader(new BernoulliNaiveBayesContentLoader());
        ScikitLearnContentLoaderFactory.registerLoader(new CategoricalNaiveBayesContentLoader());
        ScikitLearnContentLoaderFactory.registerLoader(new ComplementNaiveBayesContentLoader());
        ScikitLearnContentLoaderFactory.registerLoader(new MultinomialNaiveBayesContentLoader());
    }
}

