/*
 * Decompiled with CFR 0.152.
 */
package ai.sklearn4j.core.packaging.loaders.classifiers.naive_bayes;

import ai.sklearn4j.core.libraries.numpy.NumpyArray;
import ai.sklearn4j.core.packaging.loaders.BaseScikitLearnContentLoader;
import ai.sklearn4j.core.packaging.loaders.IScikitLearnContentLoader;
import ai.sklearn4j.naive_bayes.BernoulliNaiveBayes;

public class BernoulliNaiveBayesContentLoader
extends BaseScikitLearnContentLoader<BernoulliNaiveBayes> {
    public BernoulliNaiveBayesContentLoader() {
        super("nb_bernoulli_serializer");
    }

    @Override
    protected BernoulliNaiveBayes createResultObject() {
        return new BernoulliNaiveBayes();
    }

    @Override
    public IScikitLearnContentLoader duplicate() {
        return new BernoulliNaiveBayesContentLoader();
    }

    @Override
    protected void registerSetters() {
        this.registerNumpyArrayField("classes_", this::setClasses);
        this.registerNumpyArrayField("class_count_", this::setClassCount);
        this.registerNumpyArrayField("class_log_prior_", this::setClassLogPriors);
        this.registerNumpyArrayField("feature_log_prob_", this::setFeatureLogProbabilities);
        this.registerNumpyArrayField("feature_count_", this::setFeatureCount);
        this.registerDoubleField("binarize", this::setBinarization);
    }

    private void setBinarization(BernoulliNaiveBayes result, double value) {
        result.setBinarizationThreshold(value);
    }

    private void setFeatureLogProbabilities(BernoulliNaiveBayes result, NumpyArray numpyArray) {
        result.setFeatureLogProbabilities(numpyArray);
    }

    private void setFeatureCount(BernoulliNaiveBayes result, NumpyArray numpyArray) {
        result.setFeatureCount(numpyArray);
    }

    private void setClassLogPriors(BernoulliNaiveBayes result, NumpyArray value) {
        result.setClassLogPrior(value);
    }

    private void setClasses(BernoulliNaiveBayes result, NumpyArray value) {
        result.setClasses(value);
    }

    private void setClassCount(BernoulliNaiveBayes result, NumpyArray value) {
        result.setClassCounts(value);
    }
}

