/*
 * Decompiled with CFR 0.152.
 */
package ai.sklearn4j.core.packaging.version_1;

import ai.sklearn4j.core.packaging.BinaryModelPackage;
import ai.sklearn4j.core.packaging.IScikitLearnPackage;
import ai.sklearn4j.core.packaging.IScikitLearnPackageHeader;
import ai.sklearn4j.core.packaging.loaders.IScikitLearnContentLoader;
import ai.sklearn4j.core.packaging.loaders.ScikitLearnContentLoaderFactory;
import ai.sklearn4j.core.packaging.version_1.ScikitLearnPackageHeaderV1;
import java.util.HashMap;
import java.util.Map;

public class ScikitLearnPackageV1
implements IScikitLearnPackage {
    private ScikitLearnPackageHeaderV1 header = null;
    private Map<String, Object> primaryContent = null;
    private Map<String, Object> extras = null;

    @Override
    public IScikitLearnPackageHeader getPackageHeader() {
        return this.header;
    }

    @Override
    public Map<String, Object> getExtraValues() {
        return this.extras;
    }

    @Override
    public Object getModel(String name) {
        return this.primaryContent.get(name);
    }

    @Override
    public void loadFromFile(String path) {
        BinaryModelPackage buffer = BinaryModelPackage.fromFile(path);
        this.loadFileHeader(buffer);
        this.loadFilePrimaryContent(buffer);
        this.loadFileExtraContent(buffer);
    }

    private void loadFileExtraContent(BinaryModelPackage buffer) {
        this.extras = buffer.canRead() ? buffer.readDictionary() : new HashMap<String, Object>();
    }

    private void loadFilePrimaryContent(BinaryModelPackage buffer) {
        this.primaryContent = new HashMap<String, Object>();
        for (String serializerType : this.header.serializerTypes) {
            IScikitLearnContentLoader loader = ScikitLearnContentLoaderFactory.loaderForType(serializerType);
            String name = buffer.readString();
            this.primaryContent.put(name, loader.loadContent(buffer));
        }
    }

    private void loadFileHeader(BinaryModelPackage buffer) {
        this.header = new ScikitLearnPackageHeaderV1();
        this.header.fileFormatVersion = buffer.readInteger();
        Map<String, Object> headerValues = buffer.readDictionary();
        this.header.sklearn4xVersion = (String)headerValues.get("sklearn4x_version");
        this.header.scikitLearnVersion = (String)headerValues.get("scikit_learn_version");
        this.header.numpyVersion = (String)headerValues.get("numpy_version");
        this.header.scipyVersion = (String)headerValues.get("scipy_version");
        this.header.pythonInfo = (String)headerValues.get("python_info");
        this.header.platformInfo = (String)headerValues.get("platform_info");
        this.header.serializerTypes = (String[])headerValues.get("serializer_types");
    }
}

