/*
 * Decompiled with CFR 0.152.
 */
package ai.spice;

import ai.spice.SpiceClientBuilder;
import com.github.rholder.retry.RetryException;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import com.google.common.base.Strings;
import java.net.ConnectException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import org.apache.arrow.flight.CallOption;
import org.apache.arrow.flight.CallStatus;
import org.apache.arrow.flight.FlightClient;
import org.apache.arrow.flight.FlightClientMiddleware;
import org.apache.arrow.flight.FlightEndpoint;
import org.apache.arrow.flight.FlightInfo;
import org.apache.arrow.flight.FlightRuntimeException;
import org.apache.arrow.flight.FlightStream;
import org.apache.arrow.flight.Location;
import org.apache.arrow.flight.Ticket;
import org.apache.arrow.flight.auth2.BasicAuthCredentialWriter;
import org.apache.arrow.flight.auth2.ClientBearerHeaderHandler;
import org.apache.arrow.flight.auth2.ClientHeaderHandler;
import org.apache.arrow.flight.auth2.ClientIncomingAuthHeaderMiddleware;
import org.apache.arrow.flight.grpc.CredentialCallOption;
import org.apache.arrow.flight.sql.FlightSqlClient;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;

public class SpiceClient
implements AutoCloseable {
    private String appId;
    private String apiKey;
    private URI flightAddress;
    private URI httpAddress;
    private int maxRetries;
    private FlightSqlClient flightClient;
    private CredentialCallOption authCallOptions = null;

    public static SpiceClientBuilder builder() throws URISyntaxException {
        return new SpiceClientBuilder();
    }

    public SpiceClient(String appId, String apiKey, URI flightAddress, URI httpAddress, int maxRetries) {
        this.appId = appId;
        this.apiKey = apiKey;
        this.maxRetries = maxRetries;
        this.httpAddress = httpAddress;
        this.flightAddress = flightAddress.getScheme().equals("https") ? URI.create("grpc+tls://" + flightAddress.getHost() + ":" + flightAddress.getPort()) : (flightAddress.getScheme().equals("http") ? URI.create("grpc+tcp://" + flightAddress.getHost() + ":" + flightAddress.getPort()) : flightAddress);
        FlightClient.Builder builder = FlightClient.builder((BufferAllocator)new RootAllocator(Long.MAX_VALUE), (Location)new Location(this.flightAddress));
        if (Strings.isNullOrEmpty((String)apiKey)) {
            this.flightClient = new FlightSqlClient(builder.build());
            return;
        }
        ClientIncomingAuthHeaderMiddleware.Factory factory = new ClientIncomingAuthHeaderMiddleware.Factory((ClientHeaderHandler)new ClientBearerHeaderHandler());
        FlightClient client = builder.intercept((FlightClientMiddleware.Factory)factory).build();
        client.handshake(new CallOption[]{new CredentialCallOption((Consumer)new BasicAuthCredentialWriter(this.appId, this.apiKey))});
        this.authCallOptions = factory.getCredentialCallOption();
        this.flightClient = new FlightSqlClient(client);
    }

    public FlightStream query(String sql) throws ExecutionException {
        if (Strings.isNullOrEmpty((String)sql)) {
            throw new IllegalArgumentException("No SQL query provided");
        }
        try {
            return this.queryInternalWithRetry(sql);
        }
        catch (RetryException e) {
            Throwable err = e.getLastFailedAttempt().getExceptionCause();
            throw new ExecutionException("Failed to execute query due to error: " + err.toString(), err);
        }
    }

    public void refresh(String dataset) throws ExecutionException {
        if (Strings.isNullOrEmpty((String)dataset)) {
            throw new IllegalArgumentException("No dataset name provided");
        }
        try {
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder().uri(new URI(String.format("%s/v1/datasets/%s/acceleration/refresh", this.httpAddress, dataset))).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.noBody()).build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 201) {
                throw new ExecutionException(String.format("Failed to trigger dataset refresh. Status Code: %d, Response: %s", response.statusCode(), response.body()), null);
            }
        }
        catch (ExecutionException e) {
            throw e;
        }
        catch (ConnectException err) {
            throw new ExecutionException(String.format("The Spice runtime is unavailable at %s. Is it running?", this.httpAddress), err);
        }
        catch (Exception err) {
            throw new ExecutionException("Failed to trigger dataset refresh due to error: " + err.toString(), err);
        }
    }

    private FlightStream queryInternal(String sql) {
        FlightInfo flightInfo = this.flightClient.execute(sql, new CallOption[]{this.authCallOptions});
        Ticket ticket = ((FlightEndpoint)flightInfo.getEndpoints().get(0)).getTicket();
        return this.flightClient.getStream(ticket, new CallOption[]{this.authCallOptions});
    }

    private FlightStream queryInternalWithRetry(String sql) throws ExecutionException, RetryException {
        Retryer retryer = RetryerBuilder.newBuilder().retryIfException(throwable -> {
            if (throwable instanceof FlightRuntimeException) {
                FlightRuntimeException flightException = (FlightRuntimeException)throwable;
                CallStatus status = flightException.status();
                return this.shouldRetry(status);
            }
            return false;
        }).withWaitStrategy(WaitStrategies.fibonacciWait()).withStopStrategy(StopStrategies.stopAfterAttempt((int)(this.maxRetries + 1))).build();
        return (FlightStream)retryer.call(() -> this.queryInternal(sql));
    }

    private boolean shouldRetry(CallStatus status) {
        switch (status.code()) {
            case UNAVAILABLE: 
            case UNKNOWN: 
            case TIMED_OUT: 
            case INTERNAL: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void close() throws Exception {
        this.flightClient.close();
    }
}

