/*
 * Decompiled with CFR 0.152.
 */
package ai.spice;

import ai.spice.Config;
import ai.spice.SpiceClient;
import com.google.common.base.Strings;
import java.net.URI;
import java.net.URISyntaxException;

public class SpiceClientBuilder {
    private String appId;
    private String apiKey;
    private URI flightAddress = Config.getLocalFlightAddressUri();
    private URI httpAddress = Config.getLocalHttpAddressUri();
    private int maxRetries = 3;

    SpiceClientBuilder() throws URISyntaxException {
    }

    public SpiceClientBuilder withFlightAddress(URI flightAddress) {
        if (flightAddress == null) {
            throw new IllegalArgumentException("flightAddress can't be null");
        }
        this.flightAddress = flightAddress;
        return this;
    }

    public SpiceClientBuilder withHttpAddress(URI httpAddress) {
        if (httpAddress == null) {
            throw new IllegalArgumentException("httpAddress can't be null");
        }
        this.httpAddress = httpAddress;
        return this;
    }

    public SpiceClientBuilder withApiKey(String apiKey) {
        if (Strings.isNullOrEmpty((String)apiKey)) {
            throw new IllegalArgumentException("apiKey can't be null or empty");
        }
        String[] parts = apiKey.split("\\|");
        if (parts.length != 2) {
            throw new IllegalArgumentException("apiKey is invalid");
        }
        this.appId = parts[0];
        this.apiKey = apiKey;
        return this;
    }

    public SpiceClientBuilder withSpiceCloud() throws URISyntaxException {
        this.flightAddress = Config.getCloudFlightAddressUri();
        this.httpAddress = Config.getCloudHttpAddressUri();
        return this;
    }

    public SpiceClientBuilder withMaxRetries(int maxRetries) {
        if (maxRetries < 0) {
            throw new IllegalArgumentException("maxRetries must be greater than or equal to 0");
        }
        this.maxRetries = maxRetries;
        return this;
    }

    public SpiceClient build() {
        return new SpiceClient(this.appId, this.apiKey, this.flightAddress, this.httpAddress, this.maxRetries);
    }
}

