/*
 * Decompiled with CFR 0.152.
 */
package ai.spice.example;

import ai.spice.SpiceClient;
import java.net.URI;
import org.apache.arrow.flight.FlightStream;
import org.apache.arrow.vector.VectorSchemaRoot;

public class ExampleDatasetRefreshSpiceOSS {
    public static void main(String[] args) {
        try (SpiceClient client = SpiceClient.builder().withFlightAddress(URI.create("http://localhost:50051")).withHttpAddress(URI.create("http://localhost:8090")).build();){
            client.refresh("taxi_trips");
            System.out.println("Dataset refresh triggered for taxi_trips");
            System.out.println("Query taxi_trips dataset");
            FlightStream stream = client.query("SELECT * FROM taxi_trips LIMIT 1;");
            while (stream.next()) {
                VectorSchemaRoot batches = stream.getRoot();
                try {
                    System.out.println(batches.contentToTSVString());
                }
                finally {
                    if (batches == null) continue;
                    batches.close();
                }
            }
        }
        catch (Exception e) {
            System.err.println("An unexpected error occurred: " + e.getMessage());
        }
    }
}

