/*
 * Decompiled with CFR 0.152.
 */
package ai.spice.example;

import ai.spice.SpiceClient;
import org.apache.arrow.flight.FlightStream;
import org.apache.arrow.vector.VectorSchemaRoot;

public class ExampleSpiceCloudPlatform {
    static final String API_KEY = "api-key";

    public static void main(String[] args) {
        try (SpiceClient client = SpiceClient.builder().withApiKey(API_KEY).withSpiceCloud().build();){
            FlightStream stream = client.query("SELECT * FROM eth.recent_blocks LIMIT 10;");
            while (stream.next()) {
                VectorSchemaRoot batches = stream.getRoot();
                try {
                    System.out.println(batches.contentToTSVString());
                }
                finally {
                    if (batches == null) continue;
                    batches.close();
                }
            }
        }
        catch (Exception e) {
            System.err.println("An unexpected error occurred: " + e.getMessage());
        }
    }
}

