/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.arangograph.graphLoader;

import ai.stapi.arangograph.ArangoEdgeRepository;
import ai.stapi.arangograph.ArangoNodeRepository;
import ai.stapi.arangograph.graphLoader.arangoQuery.ArangoQuery;
import ai.stapi.arangograph.graphLoader.arangoQuery.arangoSubQueryResolver.GenericSubQueryResolver;
import ai.stapi.arangograph.graphLoader.arangoQuery.bindingObjects.ArangoEdgeFindDocument;
import ai.stapi.arangograph.graphLoader.arangoQuery.bindingObjects.ArangoEdgeGetDocument;
import ai.stapi.arangograph.graphLoader.arangoQuery.bindingObjects.ArangoNodeFindDocument;
import ai.stapi.arangograph.graphLoader.arangoQuery.bindingObjects.ArangoNodeGetDocument;
import ai.stapi.arangograph.graphLoader.arangoQuery.builder.ArangoEdgeCollectionSubQueryBuilder;
import ai.stapi.arangograph.graphLoader.arangoQuery.builder.ArangoEdgeGetSubQueryBuilder;
import ai.stapi.arangograph.graphLoader.arangoQuery.builder.ArangoNodeCollectionSubQueryBuilder;
import ai.stapi.arangograph.graphLoader.arangoQuery.builder.ArangoNodeGetSubQueryBuilder;
import ai.stapi.arangograph.graphLoader.arangoQuery.builder.ArangoQueryBuilder;
import ai.stapi.arangograph.graphLoader.arangoQuery.builder.ArangoQueryBuilderProvider;
import ai.stapi.arangograph.graphLoader.arangoQuery.builder.ArangoSubQueryBuilder;
import ai.stapi.graph.EdgeLoader;
import ai.stapi.graph.EdgeRepository;
import ai.stapi.graph.NodeRepository;
import ai.stapi.graph.RepositoryEdgeLoader;
import ai.stapi.graph.graphelements.Edge;
import ai.stapi.graph.graphelements.Node;
import ai.stapi.graph.inMemoryGraph.InMemoryGraphRepository;
import ai.stapi.graph.traversableGraphElements.TraversableEdge;
import ai.stapi.graph.traversableGraphElements.TraversableGraphElement;
import ai.stapi.graph.traversableGraphElements.TraversableNode;
import ai.stapi.graphoperations.graphLanguage.graphDescription.GraphDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.AbstractEdgeDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.AbstractNodeDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.EdgeDescriptionParameters;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.NodeDescriptionParameters;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.query.GraphElementQueryDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.query.NodeQueryGraphDescription;
import ai.stapi.graphoperations.graphLoader.GraphLoader;
import ai.stapi.graphoperations.graphLoader.GraphLoaderFindAsGraphOutput;
import ai.stapi.graphoperations.graphLoader.GraphLoaderFindAsObjectOutput;
import ai.stapi.graphoperations.graphLoader.GraphLoaderGetAsObjectOutput;
import ai.stapi.graphoperations.graphLoader.GraphLoaderReturnType;
import ai.stapi.graphoperations.graphLoader.exceptions.GraphLoaderException;
import ai.stapi.graphoperations.graphLoader.graphLoaderOGMFactory.GraphLoaderOgmFactory;
import ai.stapi.graphoperations.objectGraphLanguage.ObjectGraphMapping;
import ai.stapi.identity.UniqueIdentifier;
import com.arangodb.ArangoCollection;
import com.arangodb.ArangoDB;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.NotImplementedException;
import org.jetbrains.annotations.NotNull;

public class ArangoGraphLoader
implements GraphLoader {
    private final ArangoDB arangoDb;
    private final ArangoEdgeRepository arangoEdgeRepository;
    private final ArangoNodeRepository arangoNodeRepository;
    private final ArangoQueryBuilderProvider arangoQueryBuilderProvider;
    private final GenericSubQueryResolver genericSubQueryResolver;
    private final ObjectMapper objectMapper;
    private final GraphLoaderOgmFactory graphLoaderOgmFactory;

    public ArangoGraphLoader(ArangoDB arangoDb, ArangoEdgeRepository arangoEdgeRepository, ArangoNodeRepository arangoNodeRepository, ArangoQueryBuilderProvider arangoQueryBuilderProvider, GenericSubQueryResolver genericSubQueryResolver, ObjectMapper objectMapper, GraphLoaderOgmFactory graphLoaderOgmFactory) {
        this.arangoDb = arangoDb;
        this.arangoEdgeRepository = arangoEdgeRepository;
        this.arangoNodeRepository = arangoNodeRepository;
        this.arangoQueryBuilderProvider = arangoQueryBuilderProvider;
        this.genericSubQueryResolver = genericSubQueryResolver;
        this.objectMapper = objectMapper;
        this.graphLoaderOgmFactory = graphLoaderOgmFactory;
    }

    public List<TraversableGraphElement> findAsTraversable(GraphElementQueryDescription graphDescription) {
        String elementType;
        GraphLoaderFindAsGraphOutput output = this.find(graphDescription, Object.class, GraphLoaderReturnType.GRAPH).getGraphLoaderFindAsGraphOutput();
        if (graphDescription instanceof NodeQueryGraphDescription) {
            NodeQueryGraphDescription nodeQueryGraphDescription = (NodeQueryGraphDescription)graphDescription;
            elementType = ((NodeDescriptionParameters)nodeQueryGraphDescription.getParameters()).getNodeType();
        } else {
            elementType = ((EdgeDescriptionParameters)graphDescription.getParameters()).getEdgeType();
        }
        InMemoryGraphRepository outputRepository = output.getGraph();
        return output.getFoundGraphElementIds().stream().map(id -> outputRepository.loadGraphElement(id, elementType)).toList();
    }

    public TraversableGraphElement getAsTraversable(UniqueIdentifier elementId, GraphElementQueryDescription graphDescription) {
        String elementType;
        InMemoryGraphRepository graph = this.get(elementId, graphDescription, Object.class, GraphLoaderReturnType.GRAPH).getGraph();
        if (graphDescription instanceof NodeQueryGraphDescription) {
            NodeQueryGraphDescription nodeQueryGraphDescription = (NodeQueryGraphDescription)graphDescription;
            elementType = ((NodeDescriptionParameters)nodeQueryGraphDescription.getParameters()).getNodeType();
        } else {
            elementType = ((EdgeDescriptionParameters)graphDescription.getParameters()).getEdgeType();
        }
        return graph.loadGraphElement(elementId, elementType);
    }

    public <T> GraphLoaderFindAsObjectOutput<T> find(GraphElementQueryDescription graphDescription, Class<T> objectClass, GraphLoaderReturnType ... returnTypes) {
        GraphLoaderReturnType[] finalReturnTypes;
        String collectionType = this.getCollectionType((GraphDescription)graphDescription);
        ArangoCollection collection = this.arangoDb.db().collection(collectionType);
        if (!collection.exists()) {
            return new GraphLoaderFindAsObjectOutput();
        }
        ArangoQueryBuilder arangoQueryBuilder = this.arangoQueryBuilderProvider.provide();
        if (returnTypes.length == 0) {
            GraphLoaderReturnType[] graphLoaderReturnTypeArray = new GraphLoaderReturnType[1];
            v1 = graphLoaderReturnTypeArray;
            graphLoaderReturnTypeArray[0] = GraphLoaderReturnType.OBJECT;
        } else {
            v1 = finalReturnTypes = returnTypes;
        }
        if (graphDescription instanceof AbstractNodeDescription) {
            return this.resolveFindNodesQuery(collectionType, graphDescription, arangoQueryBuilder, objectClass, finalReturnTypes);
        }
        if (graphDescription instanceof AbstractEdgeDescription) {
            AbstractEdgeDescription edgeDescription = (AbstractEdgeDescription)graphDescription;
            return this.resolveFindEdgesQuery(collectionType, edgeDescription, arangoQueryBuilder, objectClass, finalReturnTypes);
        }
        throw new NotImplementedException("There should not be any other Query graph description, than node and edge");
    }

    public <T> GraphLoaderGetAsObjectOutput<T> get(UniqueIdentifier elementId, GraphElementQueryDescription graphDescription, Class<T> objectClass, GraphLoaderReturnType ... returnTypes) {
        GraphLoaderReturnType[] finalReturnTypes;
        String collectionType = this.getCollectionType((GraphDescription)graphDescription);
        ArangoQueryBuilder arangoQueryBuilder = this.arangoQueryBuilderProvider.provide();
        if (returnTypes.length == 0) {
            GraphLoaderReturnType[] graphLoaderReturnTypeArray = new GraphLoaderReturnType[1];
            v1 = graphLoaderReturnTypeArray;
            graphLoaderReturnTypeArray[0] = GraphLoaderReturnType.OBJECT;
        } else {
            v1 = finalReturnTypes = returnTypes;
        }
        if (graphDescription instanceof AbstractNodeDescription) {
            if (!this.arangoNodeRepository.nodeExists(elementId, collectionType)) {
                throw GraphLoaderException.becauseThereIsNoGraphElementWithProvidedUuid((UniqueIdentifier)elementId, (GraphDescription)graphDescription);
            }
            return this.resolveGetNodeQuery(elementId, collectionType, graphDescription, arangoQueryBuilder, objectClass, finalReturnTypes);
        }
        if (graphDescription instanceof AbstractEdgeDescription) {
            AbstractEdgeDescription edgeDescription = (AbstractEdgeDescription)graphDescription;
            if (!this.arangoEdgeRepository.edgeExists(elementId, collectionType)) {
                throw GraphLoaderException.becauseThereIsNoGraphElementWithProvidedUuid((UniqueIdentifier)elementId, (GraphDescription)graphDescription);
            }
            return this.resolveGetEdgeQuery(elementId, collectionType, edgeDescription, arangoQueryBuilder, objectClass, finalReturnTypes);
        }
        throw new NotImplementedException("There should not be any other Query graph description, than node and edge");
    }

    @Deprecated
    public List<TraversableNode> findAsTraversableNodesWithOriginalRepository(NodeQueryGraphDescription graphDescription) {
        GraphLoaderFindAsGraphOutput output = this.find((GraphElementQueryDescription)graphDescription, Object.class, GraphLoaderReturnType.GRAPH).getGraphLoaderFindAsGraphOutput();
        NodeDescriptionParameters nodeParam = (NodeDescriptionParameters)graphDescription.getParameters();
        return output.getFoundGraphElementIds().stream().map(uuid -> output.getGraph().loadNode(uuid, nodeParam.getNodeType())).map(oldNode -> new TraversableNode(oldNode.getId(), oldNode.getType(), oldNode.getVersionedAttributes(), (EdgeLoader)new RepositoryEdgeLoader((EdgeRepository)this.arangoEdgeRepository))).toList();
    }

    @NotNull
    private <T> GraphLoaderGetAsObjectOutput<T> resolveGetNodeQuery(UniqueIdentifier elementId, String elementType, GraphElementQueryDescription graphDescription, ArangoQueryBuilder arangoQueryBuilder, Class<T> objectClass, GraphLoaderReturnType[] returnTypes) {
        ArangoNodeGetSubQueryBuilder mainQueryBuilder = arangoQueryBuilder.setGetNodeMainQuery(elementType, elementId);
        if (Arrays.asList(returnTypes).contains(GraphLoaderReturnType.OBJECT)) {
            ObjectGraphMapping generatedOgm = this.graphLoaderOgmFactory.create((GraphDescription)graphDescription);
            this.genericSubQueryResolver.resolve((ArangoSubQueryBuilder)mainQueryBuilder, generatedOgm);
        } else {
            this.genericSubQueryResolver.resolve((ArangoSubQueryBuilder)mainQueryBuilder, (GraphDescription)graphDescription);
        }
        ArangoQuery query = arangoQueryBuilder.build(returnTypes);
        List<ArangoNodeGetDocument> getQueryArangoDocuments = this.arangoDb.db().query(query.getQueryString(), ArangoNodeGetDocument.class, query.getBindParameters()).stream().toList();
        return this.mapNodeToInMemoryGraph(getQueryArangoDocuments, objectClass);
    }

    @NotNull
    private <T> GraphLoaderGetAsObjectOutput<T> resolveGetEdgeQuery(UniqueIdentifier elementId, String elementType, AbstractEdgeDescription edgeDescription, ArangoQueryBuilder arangoQueryBuilder, Class<T> objectClass, GraphLoaderReturnType[] returnTypes) {
        ArangoEdgeGetSubQueryBuilder mainQueryBuilder = edgeDescription.isOutgoing() ? arangoQueryBuilder.setGetOutgoingEdgeMainQuery(elementType, elementId) : arangoQueryBuilder.setGetIngoingEdgeMainQuery(elementType, elementId);
        if (Arrays.asList(returnTypes).contains(GraphLoaderReturnType.OBJECT)) {
            ObjectGraphMapping generatedOgm = this.graphLoaderOgmFactory.create((GraphDescription)edgeDescription);
            this.genericSubQueryResolver.resolve((ArangoSubQueryBuilder)mainQueryBuilder, generatedOgm);
        } else {
            this.genericSubQueryResolver.resolve((ArangoSubQueryBuilder)mainQueryBuilder, (GraphDescription)edgeDescription);
        }
        ArangoQuery query = arangoQueryBuilder.build(returnTypes);
        List<ArangoEdgeGetDocument> getQueryArangoDocuments = this.arangoDb.db().query(query.getQueryString(), ArangoEdgeGetDocument.class, query.getBindParameters()).stream().toList();
        return this.mapEdgeToInMemoryGraph(getQueryArangoDocuments, objectClass);
    }

    @NotNull
    private <T> GraphLoaderFindAsObjectOutput<T> resolveFindNodesQuery(String elementType, GraphElementQueryDescription graphDescription, ArangoQueryBuilder arangoQueryBuilder, Class<T> objectClass, GraphLoaderReturnType[] returnTypes) {
        ArangoNodeCollectionSubQueryBuilder mainQueryBuilder = arangoQueryBuilder.setFindNodesMainQuery(elementType);
        if (Arrays.asList(returnTypes).contains(GraphLoaderReturnType.OBJECT)) {
            ObjectGraphMapping generatedOgm = this.graphLoaderOgmFactory.create((GraphDescription)graphDescription);
            this.genericSubQueryResolver.resolve((ArangoSubQueryBuilder)mainQueryBuilder, generatedOgm);
        } else {
            this.genericSubQueryResolver.resolve((ArangoSubQueryBuilder)mainQueryBuilder, (GraphDescription)graphDescription);
        }
        ArangoQuery query = arangoQueryBuilder.build(returnTypes);
        List<ArangoNodeFindDocument> findQueryArangoDocuments = this.arangoDb.db().query(query.getQueryString(), ArangoNodeFindDocument.class, query.getBindParameters()).stream().toList();
        return this.mapNodesToGraphLoaderOutput(findQueryArangoDocuments, objectClass);
    }

    @NotNull
    private <T> GraphLoaderFindAsObjectOutput<T> resolveFindEdgesQuery(String elementType, AbstractEdgeDescription edgeDescription, ArangoQueryBuilder arangoQueryBuilder, Class<T> objectClass, GraphLoaderReturnType[] returnTypes) {
        ArangoEdgeCollectionSubQueryBuilder mainQueryBuilder = edgeDescription.isOutgoing() ? arangoQueryBuilder.setFindOutgoingEdgeMainQuery(elementType) : arangoQueryBuilder.setFindIngoingEdgeMainQuery(elementType);
        if (Arrays.asList(returnTypes).contains(GraphLoaderReturnType.OBJECT)) {
            ObjectGraphMapping generatedOgm = this.graphLoaderOgmFactory.create((GraphDescription)edgeDescription);
            this.genericSubQueryResolver.resolve((ArangoSubQueryBuilder)mainQueryBuilder, generatedOgm);
        } else {
            this.genericSubQueryResolver.resolve((ArangoSubQueryBuilder)mainQueryBuilder, (GraphDescription)edgeDescription);
        }
        ArangoQuery query = arangoQueryBuilder.build(returnTypes);
        List<ArangoEdgeFindDocument> findQueryArangoDocuments = this.arangoDb.db().query(query.getQueryString(), ArangoEdgeFindDocument.class, query.getBindParameters()).stream().toList();
        return this.mapEdgesToGraphLoaderOutput(findQueryArangoDocuments, objectClass);
    }

    @NotNull
    private <T> GraphLoaderFindAsObjectOutput<T> mapNodesToGraphLoaderOutput(List<ArangoNodeFindDocument> results, Class<T> objectClass) {
        InMemoryGraphRepository graph = new InMemoryGraphRepository();
        ArrayList originUuids = new ArrayList();
        results.forEach(result -> {
            if (result.getGraphResponse().getMainGraphElements() == null) {
                return;
            }
            result.getGraphResponse().getMainGraphElements().forEach(baseDocument -> {
                TraversableNode traversableNode = TraversableNode.from((Node)baseDocument, (EdgeRepository)graph);
                graph.save(new Node(traversableNode));
                originUuids.add(traversableNode.getId());
            });
            result.getGraphResponse().getNodes().forEach(arg_0 -> ((InMemoryGraphRepository)graph).save(arg_0));
            result.getGraphResponse().getEdges().forEach(arg_0 -> ((InMemoryGraphRepository)graph).save(arg_0));
        });
        ArrayList finalData = new ArrayList();
        results.forEach(result -> finalData.addAll(result.getData().stream().map(data -> this.objectMapper.convertValue(data, objectClass)).toList()));
        return new GraphLoaderFindAsObjectOutput(finalData, originUuids, graph);
    }

    @NotNull
    private <T> GraphLoaderFindAsObjectOutput<T> mapEdgesToGraphLoaderOutput(List<ArangoEdgeFindDocument> results, Class<T> objectClass) {
        InMemoryGraphRepository graph = new InMemoryGraphRepository();
        ArrayList originUUIDs = new ArrayList();
        results.forEach(result -> {
            if (result.getGraphResponse().getMainGraphElements() == null) {
                return;
            }
            result.getGraphResponse().getNodes().forEach(arg_0 -> ((InMemoryGraphRepository)graph).save(arg_0));
            result.getGraphResponse().getMainGraphElements().forEach(baseDocument -> {
                TraversableEdge traversableEdge = TraversableEdge.from((Edge)baseDocument, (NodeRepository)graph);
                graph.save(new Edge(traversableEdge));
                originUUIDs.add(traversableEdge.getId());
            });
            result.getGraphResponse().getEdges().forEach(arg_0 -> ((InMemoryGraphRepository)graph).save(arg_0));
        });
        ArrayList finalData = new ArrayList();
        results.forEach(result -> finalData.addAll(result.getData().stream().map(data -> this.objectMapper.convertValue(data, objectClass)).toList()));
        return new GraphLoaderFindAsObjectOutput(finalData, originUUIDs, graph);
    }

    @NotNull
    private <T> GraphLoaderGetAsObjectOutput<T> mapNodeToInMemoryGraph(List<ArangoNodeGetDocument> results, Class<T> objectClass) {
        InMemoryGraphRepository graph = new InMemoryGraphRepository();
        results.forEach(result -> {
            if (result.getGraphResponse().getMainGraphElement() == null) {
                return;
            }
            Node main = result.getGraphResponse().getMainGraphElement();
            graph.save(main);
            result.getGraphResponse().getNodes().forEach(arg_0 -> ((InMemoryGraphRepository)graph).save(arg_0));
            result.getGraphResponse().getEdges().forEach(arg_0 -> ((InMemoryGraphRepository)graph).save(arg_0));
        });
        Object data = results.get(0).getData();
        return new GraphLoaderGetAsObjectOutput(this.objectMapper.convertValue(data, objectClass), graph);
    }

    @NotNull
    private <T> GraphLoaderGetAsObjectOutput<T> mapEdgeToInMemoryGraph(List<ArangoEdgeGetDocument> results, Class<T> objectClass) {
        InMemoryGraphRepository graph = new InMemoryGraphRepository();
        results.forEach(result -> {
            if (result.getGraphResponse().getMainGraphElement() == null) {
                return;
            }
            result.getGraphResponse().getNodes().forEach(arg_0 -> ((InMemoryGraphRepository)graph).save(arg_0));
            Edge main = result.getGraphResponse().getMainGraphElement();
            TraversableEdge traversableEdge = TraversableEdge.from((Edge)main, (NodeRepository)graph);
            graph.save(new Edge(traversableEdge));
            result.getGraphResponse().getEdges().forEach(arg_0 -> ((InMemoryGraphRepository)graph).save(arg_0));
        });
        Object data = results.get(0).getData();
        return new GraphLoaderGetAsObjectOutput(this.objectMapper.convertValue(data, objectClass), graph);
    }

    private String getCollectionType(GraphDescription graphDescription) {
        if (graphDescription instanceof AbstractNodeDescription) {
            NodeDescriptionParameters params = (NodeDescriptionParameters)graphDescription.getParameters();
            return params.getNodeType();
        }
        if (graphDescription instanceof AbstractEdgeDescription) {
            EdgeDescriptionParameters params = (EdgeDescriptionParameters)graphDescription.getParameters();
            return params.getEdgeType();
        }
        throw new NotImplementedException("There should never be any other graph descriptions");
    }
}

