/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.arangograph.graphLoader.arangoQuery.ast.highLevelOperations;

import ai.stapi.arangograph.graphLoader.arangoQuery.ast.AqlInteger;
import ai.stapi.arangograph.graphLoader.arangoQuery.ast.AqlNode;
import ai.stapi.arangograph.graphLoader.arangoQuery.ast.AqlVariable;
import ai.stapi.arangograph.graphLoader.arangoQuery.ast.highLevelOperations.TraversalDirection;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class AqlGraphTraversalFor
implements AqlNode {
    private final AqlVariable nodeVariable;
    private final TraversalDirection traversalDirection;
    private final AqlNode startNode;
    private final List<AqlNode> edgeCollections;
    @Nullable
    private final AqlVariable edgeVariable;
    @Nullable
    private final AqlVariable pathVariable;
    @Nullable
    private final AqlInteger min;
    @Nullable
    private final AqlInteger max;

    public AqlGraphTraversalFor(AqlVariable nodeVariable, TraversalDirection traversalDirection, AqlNode startNode, List<AqlNode> edgeCollections, @Nullable AqlVariable edgeVariable, @Nullable AqlVariable pathVariable, @Nullable AqlInteger min, @Nullable AqlInteger max) {
        this.nodeVariable = nodeVariable;
        this.traversalDirection = traversalDirection;
        this.startNode = startNode;
        this.edgeCollections = edgeCollections;
        this.edgeVariable = edgeVariable;
        this.pathVariable = pathVariable;
        this.min = min;
        this.max = max;
    }

    public AqlVariable getNodeVariable() {
        return this.nodeVariable;
    }

    public TraversalDirection getTraversalDirection() {
        return this.traversalDirection;
    }

    public AqlNode getStartNode() {
        return this.startNode;
    }

    public List<AqlNode> getEdgeCollections() {
        return this.edgeCollections;
    }

    @Nullable
    public AqlVariable getEdgeVariable() {
        return this.edgeVariable;
    }

    @Nullable
    public AqlVariable getPathVariable() {
        return this.pathVariable;
    }

    @Nullable
    public AqlInteger getMin() {
        return this.min;
    }

    @Nullable
    public AqlInteger getMax() {
        return this.max;
    }

    @Override
    public String toQueryString() {
        return String.format("FOR %s IN %s %s %s %s", new Object[]{this.createForVariables(), this.createMinMax(), this.traversalDirection, this.startNode.toQueryString(), this.edgeCollections.stream().map(AqlNode::toQueryString).collect(Collectors.joining(", "))});
    }

    private String createForVariables() {
        ArrayList<String> variables = new ArrayList<String>();
        variables.add(this.nodeVariable.toQueryString());
        if (this.edgeVariable != null) {
            variables.add(this.edgeVariable.toQueryString());
        }
        if (this.pathVariable != null) {
            variables.add(this.pathVariable.toQueryString());
        }
        return String.join((CharSequence)", ", variables);
    }

    private String createMinMax() {
        if (this.min == null) {
            return "";
        }
        if (this.max == null) {
            return this.min.toQueryString();
        }
        return String.format("%s..%s", this.min.toQueryString(), this.max.toQueryString());
    }
}

