/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.arangograph.graphLoader.arangoQuery.builder;

import ai.stapi.arangograph.graphLoader.arangoQuery.ArangoQuery;
import ai.stapi.arangograph.graphLoader.arangoQuery.ast.AqlVariable;
import ai.stapi.arangograph.graphLoader.arangoQuery.ast.highLevelOperations.AqlReturn;
import ai.stapi.arangograph.graphLoader.arangoQuery.builder.ArangoGraphTraversalJoinable;
import ai.stapi.arangograph.graphLoader.arangoQuery.builder.ArangoGraphTraversalSubQueryBuilder;
import ai.stapi.arangograph.graphLoader.arangoQuery.builder.ArangoMappedObjectBuilder;
import ai.stapi.arangograph.graphLoader.arangoQuery.builder.ArangoNodeKeptAttributesBuilder;
import ai.stapi.arangograph.graphLoader.arangoQuery.builder.ArangoSubQueryBuilder;
import ai.stapi.arangograph.graphLoader.arangoQuery.searchOptionResolvers.ArangoGenericSearchOptionResolver;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.AbstractEdgeDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.EdgeDescriptionParameters;
import ai.stapi.graphoperations.graphLoader.GraphLoaderReturnType;
import ai.stapi.schema.structureSchema.FieldDefinition;
import ai.stapi.schema.structureSchemaProvider.StructureSchemaFinder;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class ArangoGraphTraversalNodeOptionBuilder
implements ArangoGraphTraversalJoinable,
ArangoSubQueryBuilder {
    private final StructureSchemaFinder structureSchemaFinder;
    private final ArangoGenericSearchOptionResolver searchOptionResolver;
    private final ArangoNodeKeptAttributesBuilder keptAttributesBuilder;
    private final ArangoMappedObjectBuilder mappedObjectBuilder;
    private final String subQueryPostfix;
    private final Map<String, ArangoGraphTraversalSubQueryBuilder> subQueryBuilders;
    private final String nodeType;
    private final AqlVariable nodeDocumentVariable;

    public ArangoGraphTraversalNodeOptionBuilder(StructureSchemaFinder structureSchemaFinder, ArangoGenericSearchOptionResolver searchOptionResolver, String graphElementType, String subQueryPostfix, AqlVariable nodeDocumentVariable) {
        this.structureSchemaFinder = structureSchemaFinder;
        this.searchOptionResolver = searchOptionResolver;
        this.subQueryPostfix = subQueryPostfix;
        this.nodeType = graphElementType;
        this.nodeDocumentVariable = nodeDocumentVariable;
        this.keptAttributesBuilder = new ArangoNodeKeptAttributesBuilder(this.structureSchemaFinder, nodeDocumentVariable, this.subQueryPostfix, this.nodeType);
        this.mappedObjectBuilder = new ArangoMappedObjectBuilder(this.keptAttributesBuilder, this.structureSchemaFinder, nodeDocumentVariable, "node_" + this.subQueryPostfix, graphElementType);
        this.subQueryBuilders = new HashMap<String, ArangoGraphTraversalSubQueryBuilder>();
    }

    @NotNull
    private static String getSubQueryVariable(String childSubQueryPrefix) {
        return "subQuery_graphTraverOption_" + childSubQueryPrefix;
    }

    public ArangoMappedObjectBuilder setMappedScalars() {
        return this.mappedObjectBuilder;
    }

    public ArangoNodeKeptAttributesBuilder setKeptAttributes() {
        return this.keptAttributesBuilder;
    }

    @Override
    public ArangoGraphTraversalSubQueryBuilder joinGraphTraversal(AbstractEdgeDescription edgeDescription) {
        String childSubQueryPrefix = this.getChildSubQueryPostfix();
        ArangoGraphTraversalSubQueryBuilder subQueryBuilder = new ArangoGraphTraversalSubQueryBuilder(this.searchOptionResolver, this.structureSchemaFinder, edgeDescription, childSubQueryPrefix, this.nodeDocumentVariable);
        this.subQueryBuilders.put(ArangoGraphTraversalNodeOptionBuilder.getSubQueryVariable(childSubQueryPrefix), subQueryBuilder);
        return subQueryBuilder;
    }

    @Override
    public ArangoGraphTraversalSubQueryBuilder mapGraphTraversal(String fieldName, AbstractEdgeDescription edgeDescription) {
        String childSubQueryPrefix = this.getChildSubQueryPostfix();
        String subQueryVariable = ArangoGraphTraversalNodeOptionBuilder.getSubQueryVariable(childSubQueryPrefix);
        String edgeType = ((EdgeDescriptionParameters)edgeDescription.getParameters()).getEdgeType();
        FieldDefinition fieldDefinition = this.structureSchemaFinder.getFieldDefinitionOrFallback(this.nodeType, edgeType);
        if (fieldDefinition.isList()) {
            this.mappedObjectBuilder.mapCustomField(fieldName, new AqlVariable(subQueryVariable + "[*].data"));
        } else {
            this.mappedObjectBuilder.mapCustomField(fieldName, new AqlVariable(subQueryVariable + "[0].data"));
        }
        ArangoGraphTraversalSubQueryBuilder subQueryBuilder = new ArangoGraphTraversalSubQueryBuilder(this.searchOptionResolver, this.structureSchemaFinder, edgeDescription, childSubQueryPrefix, this.nodeDocumentVariable);
        this.subQueryBuilders.put(subQueryVariable, subQueryBuilder);
        return subQueryBuilder;
    }

    @Override
    public ArangoGraphTraversalSubQueryBuilder mapGraphTraversalAsConnections(String fieldName, AbstractEdgeDescription edgeDescription) {
        String childSubQueryPrefix = this.getChildSubQueryPostfix();
        String subQueryVariable = ArangoGraphTraversalNodeOptionBuilder.getSubQueryVariable(childSubQueryPrefix);
        String edgeType = ((EdgeDescriptionParameters)edgeDescription.getParameters()).getEdgeType();
        FieldDefinition fieldDefinition = this.structureSchemaFinder.getFieldDefinitionOrFallback(this.nodeType, edgeType);
        if (fieldDefinition.isList()) {
            this.mappedObjectBuilder.mapCustomField(fieldName + "Connections", new AqlVariable(subQueryVariable + "[*].data"));
        } else {
            this.mappedObjectBuilder.mapCustomField(fieldName + "Connections", new AqlVariable(subQueryVariable + "[0].data"));
        }
        ArangoGraphTraversalSubQueryBuilder subQueryBuilder = ArangoGraphTraversalSubQueryBuilder.asConnections(this.searchOptionResolver, this.structureSchemaFinder, edgeDescription, childSubQueryPrefix, this.nodeDocumentVariable);
        this.subQueryBuilders.put(subQueryVariable, subQueryBuilder);
        return subQueryBuilder;
    }

    @Override
    public ArangoQuery build(GraphLoaderReturnType ... returnTypes) {
        Map<String, ArangoQuery> buildSubQueries = this.buildSubQueries(returnTypes);
        ArangoQuery keptAttributes = this.keptAttributesBuilder.build();
        ArangoQuery mappedObject = this.mappedObjectBuilder.build();
        HashMap<String, Object> finalBindParameters = new HashMap<String, Object>();
        finalBindParameters.putAll(keptAttributes.getBindParameters());
        finalBindParameters.putAll(mappedObject.getBindParameters());
        buildSubQueries.values().forEach(query -> finalBindParameters.putAll(query.getBindParameters()));
        return new ArangoQuery(new AqlVariable(this.buildQueryString(buildSubQueries, keptAttributes, mappedObject, returnTypes)), finalBindParameters);
    }

    @NotNull
    private String buildQueryString(Map<String, ArangoQuery> subQueries, ArangoQuery keptAttributes, ArangoQuery mappedObject, GraphLoaderReturnType ... returnTypes) {
        String subQueryString = this.buildSubQueriesString(subQueries);
        Set set = Arrays.stream(returnTypes).collect(Collectors.toSet());
        if (set.contains(GraphLoaderReturnType.SORT_OPTION)) {
            if (this.keptAttributesBuilder.isExactlyOneAttributeSet()) {
                return new AqlReturn(this.keptAttributesBuilder.buildOneAttributeFirstValue()).toQueryString();
            }
            return String.format("%s RETURN %s[0]", subQueryString, this.subQueryBuilders.keySet().iterator().next());
        }
        if (set.contains(GraphLoaderReturnType.FILTER_OPTION)) {
            if (this.keptAttributesBuilder.isExactlyOneAttributeSet()) {
                return new AqlReturn(this.keptAttributesBuilder.buildOneListOrLeafAttribute()).toQueryString();
            }
            Map.Entry<String, ArangoGraphTraversalSubQueryBuilder> graphTraversalBuilderEntry = this.subQueryBuilders.entrySet().iterator().next();
            FieldDefinition fieldDefinition = this.structureSchemaFinder.getFieldDefinitionOrFallback(this.nodeType, graphTraversalBuilderEntry.getValue().getEdgeType());
            return String.format("%s RETURN %s%s", subQueryString, graphTraversalBuilderEntry.getKey(), fieldDefinition.isList() ? "" : "[0]");
        }
        String graph = String.format("{ edges: %s, nodes: PUSH(%s, %s) }", this.buildJoinedEdges(), this.buildJoinedNodes(), keptAttributes.getQueryString());
        return String.format("%s RETURN { data: %s, graphResponse: %s }", subQueryString, set.contains(GraphLoaderReturnType.OBJECT) ? mappedObject.getQueryString() : "{}", set.contains(GraphLoaderReturnType.GRAPH) ? graph : "{}");
    }

    private Map<String, ArangoQuery> buildSubQueries(GraphLoaderReturnType ... returnTypes) {
        return this.subQueryBuilders.entrySet().stream().map(entry -> new AbstractMap.SimpleEntry<String, ArangoQuery>((String)entry.getKey(), ((ArangoGraphTraversalSubQueryBuilder)entry.getValue()).build(returnTypes))).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    }

    private String buildSubQueriesString(Map<String, ArangoQuery> subQueries) {
        List<String> strings = subQueries.entrySet().stream().map(entry -> this.buildSubQueryString((String)entry.getKey(), ((ArangoQuery)entry.getValue()).getQueryString())).toList();
        return String.join((CharSequence)" ", strings);
    }

    private String buildSubQueryString(String variableKey, String subQueryString) {
        String variableAssignmentStatement = "LET " + variableKey + " = (";
        String endStatement = ")";
        return String.join((CharSequence)" ", variableAssignmentStatement, subQueryString, endStatement);
    }

    protected String buildJoinedEdges() {
        if (this.subQueryBuilders.size() == 0) {
            return "[]";
        }
        if (this.subQueryBuilders.size() == 1) {
            String key2 = String.join((CharSequence)"", this.subQueryBuilders.keySet());
            return key2 + "[*].graphResponse.edges[**]";
        }
        return "UNION(" + this.subQueryBuilders.keySet().stream().map(key -> key + "[*].graphResponse.edges[**]").collect(Collectors.joining(", ")) + ")";
    }

    protected String buildJoinedNodes() {
        if (this.subQueryBuilders.size() == 0) {
            return "[]";
        }
        if (this.subQueryBuilders.size() == 1) {
            String key2 = String.join((CharSequence)"", this.subQueryBuilders.keySet());
            return key2 + "[*].graphResponse.nodes[**]";
        }
        return "UNION(" + this.subQueryBuilders.keySet().stream().map(key -> key + "[*].graphResponse.nodes[**]").collect(Collectors.joining(", ")) + ")";
    }

    private AqlVariable buildDocumentName() {
        if (this.subQueryPostfix.isBlank()) {
            return new AqlVariable("nodeElement");
        }
        return new AqlVariable("nodeElement_" + this.subQueryPostfix);
    }

    protected String getChildSubQueryPostfix() {
        if (this.subQueryPostfix.isBlank()) {
            return String.valueOf(this.subQueryBuilders.size());
        }
        return this.subQueryPostfix + "_" + this.subQueryBuilders.size();
    }
}

