/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.arangograph.graphLoader.arangoQuery.builder;

import ai.stapi.arangograph.graphLoader.arangoQuery.ArangoQuery;
import ai.stapi.arangograph.graphLoader.arangoQuery.ast.AqlNode;
import ai.stapi.arangograph.graphLoader.arangoQuery.ast.AqlObject;
import ai.stapi.arangograph.graphLoader.arangoQuery.ast.AqlString;
import ai.stapi.arangograph.graphLoader.arangoQuery.ast.AqlVariable;
import ai.stapi.arangograph.graphLoader.arangoQuery.ast.functions.AqlKeep;
import ai.stapi.schema.structureSchema.FieldDefinition;
import ai.stapi.schema.structureSchemaProvider.StructureSchemaFinder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ArangoKeptAttributesBuilder {
    protected final AqlVariable documentName;
    protected final String subQueryPostfix;
    protected final Map<String, Object> bindParameters;
    protected final List<AqlNode> attributesToKeep;
    private final StructureSchemaFinder structureSchemaFinder;
    private final String graphElementType;
    private boolean keepAllAttributes = false;
    private boolean keepId = false;

    protected ArangoKeptAttributesBuilder(StructureSchemaFinder structureSchemaFinder, AqlVariable documentName, String subQueryPostfix, String graphElementType) {
        this.structureSchemaFinder = structureSchemaFinder;
        this.documentName = documentName;
        this.subQueryPostfix = subQueryPostfix;
        this.graphElementType = graphElementType;
        this.bindParameters = new HashMap<String, Object>();
        this.attributesToKeep = new ArrayList<AqlNode>();
    }

    protected abstract String[] provideDefaultMetaAttributes();

    public ArangoKeptAttributesBuilder addId() {
        this.keepId = true;
        return this;
    }

    public ArangoKeptAttributesBuilder addAttribute(String attributeName) {
        String postfix = this.subQueryPostfix.isBlank() ? "" : "__" + this.subQueryPostfix;
        String placeHolder = "keptAttributeName_" + this.attributesToKeep.size() + postfix;
        this.attributesToKeep.add(new AqlVariable("@" + placeHolder));
        this.bindParameters.put(placeHolder, attributeName);
        return this;
    }

    public ArangoKeptAttributesBuilder addAttribute(String attributeName, String placeholder) {
        this.attributesToKeep.add(new AqlVariable("@" + placeholder));
        this.bindParameters.put(placeholder, attributeName);
        return this;
    }

    public ArangoKeptAttributesBuilder keepAllAttributes() {
        this.keepAllAttributes = true;
        return this;
    }

    protected ArangoQuery build() {
        return new ArangoQuery(this.buildAqlObject(), this.bindParameters);
    }

    public AqlNode buildOneAttributeFirstValue() {
        if (this.keepId) {
            return this.documentName.getField("_key");
        }
        return this.buildOneAttribute().getItem(0).getField("value");
    }

    public AqlNode buildOneListOrLeafAttribute() {
        if (this.keepId) {
            return this.documentName.getField("_key");
        }
        AqlNode attribute = this.buildOneAttribute();
        String attributeName = (String)this.bindParameters.values().iterator().next();
        FieldDefinition fieldDefinition = this.structureSchemaFinder.getFieldDefinitionOrFallback(this.graphElementType, attributeName);
        if (!fieldDefinition.isList()) {
            return attribute.getItem(0).getField("value");
        }
        return attribute.getAllItems().getField("value");
    }

    private AqlNode buildOneAttribute() {
        return this.documentName.getField("attributes").getField(this.attributesToKeep.get(0).toQueryString()).getItem(0).getField("values");
    }

    private AqlNode buildAqlObject() {
        if (this.keepAllAttributes) {
            return this.documentName;
        }
        HashMap<AqlNode, AqlNode> fieldMap = new HashMap<AqlNode, AqlNode>();
        Arrays.stream(this.provideDefaultMetaAttributes()).forEach(metaAttribute -> fieldMap.put(new AqlString((String)metaAttribute), this.documentName.getField((String)metaAttribute)));
        AqlKeep keep = new AqlKeep(this.documentName.getField("attributes"), this.attributesToKeep);
        fieldMap.put(new AqlString("attributes"), this.attributesToKeep.isEmpty() ? new AqlObject(Map.of()) : keep);
        return new AqlObject(fieldMap);
    }

    public boolean isExactlyOneAttributeSet() {
        return this.attributesToKeep.size() == 1 || this.keepId;
    }
}

