/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.arangograph.graphLoader.arangoQuery.builder;

import ai.stapi.arangograph.graphLoader.arangoQuery.ArangoQuery;
import ai.stapi.arangograph.graphLoader.arangoQuery.ArangoQueryType;
import ai.stapi.arangograph.graphLoader.arangoQuery.ast.AqlList;
import ai.stapi.arangograph.graphLoader.arangoQuery.ast.AqlNode;
import ai.stapi.arangograph.graphLoader.arangoQuery.ast.AqlObject;
import ai.stapi.arangograph.graphLoader.arangoQuery.ast.AqlRootNode;
import ai.stapi.arangograph.graphLoader.arangoQuery.ast.AqlVariable;
import ai.stapi.arangograph.graphLoader.arangoQuery.ast.functions.AqlUnion;
import ai.stapi.arangograph.graphLoader.arangoQuery.ast.highLevelOperations.AqlLet;
import ai.stapi.arangograph.graphLoader.arangoQuery.ast.highLevelOperations.AqlReturn;
import ai.stapi.arangograph.graphLoader.arangoQuery.builder.ArangoGraphTraversalJoinable;
import ai.stapi.arangograph.graphLoader.arangoQuery.builder.ArangoGraphTraversalSubQueryBuilder;
import ai.stapi.arangograph.graphLoader.arangoQuery.builder.ArangoMainQueryBuilder;
import ai.stapi.arangograph.graphLoader.arangoQuery.builder.ArangoMappedObjectBuilder;
import ai.stapi.arangograph.graphLoader.arangoQuery.builder.ArangoNodeKeptAttributesBuilder;
import ai.stapi.arangograph.graphLoader.arangoQuery.builder.ArangoSearchOptionsBuilder;
import ai.stapi.arangograph.graphLoader.arangoQuery.searchOptionResolvers.ArangoGenericSearchOptionResolver;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.AbstractEdgeDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.EdgeDescriptionParameters;
import ai.stapi.graphoperations.graphLoader.GraphLoaderReturnType;
import ai.stapi.schema.structureSchema.FieldDefinition;
import ai.stapi.schema.structureSchemaProvider.StructureSchemaFinder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public abstract class ArangoNodeSubQueryBuilder
implements ArangoMainQueryBuilder,
ArangoGraphTraversalJoinable {
    protected final ArangoGenericSearchOptionResolver searchOptionResolver;
    protected final StructureSchemaFinder structureSchemaFinder;
    protected final ArangoNodeKeptAttributesBuilder arangoNodeKeptAttributesBuilder;
    protected final ArangoMappedObjectBuilder arangoMappedObjectBuilder;
    protected final ArangoSearchOptionsBuilder arangoSearchOptionsBuilder;
    protected final String graphElementType;
    protected final String subQueryPostfix;
    protected final Map<String, ArangoGraphTraversalSubQueryBuilder> subQueryBuilders;
    protected final Map<String, Object> bindParameters;

    public ArangoNodeSubQueryBuilder(ArangoGenericSearchOptionResolver searchOptionResolver, StructureSchemaFinder structureSchemaFinder, String graphElementType, String subQueryPostfix) {
        this.searchOptionResolver = searchOptionResolver;
        this.structureSchemaFinder = structureSchemaFinder;
        this.graphElementType = graphElementType;
        this.subQueryPostfix = subQueryPostfix;
        AqlVariable nodeDocumentName = this.createNodeDocumentName(this.subQueryPostfix);
        this.arangoNodeKeptAttributesBuilder = new ArangoNodeKeptAttributesBuilder(this.structureSchemaFinder, nodeDocumentName, this.subQueryPostfix, this.graphElementType);
        this.arangoMappedObjectBuilder = new ArangoMappedObjectBuilder(this.arangoNodeKeptAttributesBuilder, this.structureSchemaFinder, nodeDocumentName, this.subQueryPostfix, this.graphElementType);
        this.arangoSearchOptionsBuilder = new ArangoSearchOptionsBuilder(this.searchOptionResolver, nodeDocumentName, ArangoQueryType.NODE, this.graphElementType, this.subQueryPostfix);
        this.subQueryBuilders = new LinkedHashMap<String, ArangoGraphTraversalSubQueryBuilder>();
        this.bindParameters = new HashMap<String, Object>();
    }

    public ArangoNodeKeptAttributesBuilder setKeptAttributes() {
        return this.arangoNodeKeptAttributesBuilder;
    }

    public ArangoMappedObjectBuilder setMappedScalars() {
        return this.arangoMappedObjectBuilder;
    }

    public ArangoSearchOptionsBuilder setSearchOptions() {
        return this.arangoSearchOptionsBuilder;
    }

    @Override
    public ArangoGraphTraversalSubQueryBuilder joinGraphTraversal(AbstractEdgeDescription edgeDescription) {
        String childSubQueryPrefix = this.getChildSubQueryPostfix();
        ArangoGraphTraversalSubQueryBuilder subQueryBuilder = new ArangoGraphTraversalSubQueryBuilder(this.searchOptionResolver, this.structureSchemaFinder, edgeDescription, childSubQueryPrefix, this.createNodeDocumentName(this.subQueryPostfix));
        this.subQueryBuilders.put(this.createSubQueryVariable(childSubQueryPrefix).getVariableName(), subQueryBuilder);
        return subQueryBuilder;
    }

    @Override
    public ArangoGraphTraversalSubQueryBuilder mapGraphTraversal(String fieldName, AbstractEdgeDescription edgeDescription) {
        String childSubQueryPrefix = this.getChildSubQueryPostfix();
        AqlVariable subQueryVariable = this.createSubQueryVariable(childSubQueryPrefix);
        this.mapGraphTraversalJoin(edgeDescription, fieldName, subQueryVariable);
        ArangoGraphTraversalSubQueryBuilder subQueryBuilder = new ArangoGraphTraversalSubQueryBuilder(this.searchOptionResolver, this.structureSchemaFinder, edgeDescription, childSubQueryPrefix, this.createNodeDocumentName(this.subQueryPostfix));
        this.subQueryBuilders.put(subQueryVariable.getVariableName(), subQueryBuilder);
        return subQueryBuilder;
    }

    @Override
    public ArangoGraphTraversalSubQueryBuilder mapGraphTraversalAsConnections(String fieldName, AbstractEdgeDescription edgeDescription) {
        String connectionFieldName = fieldName + "Connections";
        String childSubQueryPrefix = this.getChildSubQueryPostfix();
        AqlVariable subQueryVariable = this.createSubQueryVariable(childSubQueryPrefix);
        this.mapGraphTraversalJoin(edgeDescription, connectionFieldName, subQueryVariable);
        ArangoGraphTraversalSubQueryBuilder subQueryBuilder = ArangoGraphTraversalSubQueryBuilder.asConnections(this.searchOptionResolver, this.structureSchemaFinder, edgeDescription, childSubQueryPrefix, this.createNodeDocumentName(this.subQueryPostfix));
        this.subQueryBuilders.put(subQueryVariable.getVariableName(), subQueryBuilder);
        return subQueryBuilder;
    }

    @Override
    public ArangoQuery build(GraphLoaderReturnType ... returnTypes) {
        ArangoQuery keptAttributes = this.arangoNodeKeptAttributesBuilder.build();
        AqlNode nodes = this.createNodes(keptAttributes);
        AqlNode edges = this.createEdges();
        AqlObject graph = this.createGraphObject(nodes, edges);
        return this.createAqlBody(keptAttributes, graph, returnTypes);
    }

    @Override
    public ArangoQuery buildAsMain(GraphLoaderReturnType ... returnTypes) {
        ArangoQuery keptAttributes = this.arangoNodeKeptAttributesBuilder.build();
        AqlNode main = keptAttributes.getAqlNode();
        AqlNode nodes = this.createNodes();
        AqlNode edges = this.createEdges();
        AqlObject graph = this.createMainGraphObject(main, nodes, edges);
        return this.createAqlBody(keptAttributes, graph, returnTypes);
    }

    @NotNull
    protected abstract ArangoQuery createAqlBody(ArangoQuery var1, AqlObject var2, GraphLoaderReturnType ... var3);

    @NotNull
    protected ArangoQuery createBaseAqlBody(ArangoQuery keptAttributes, AqlObject graph, AqlNode getDocumentLine, GraphLoaderReturnType ... returnTypes) {
        ArangoQuery mappedObject = this.arangoMappedObjectBuilder.build();
        ArangoQuery searchOptions = this.arangoSearchOptionsBuilder.build();
        ArrayList subQueryStatements = new ArrayList();
        ArrayList<Map> subQueryBindParams = new ArrayList<Map>();
        this.subQueryBuilders.forEach((key, value) -> {
            ArangoQuery arangoQuery = value.build(returnTypes);
            subQueryStatements.add(new AqlLet(new AqlVariable((String)key), arangoQuery.getAqlNode()));
            subQueryBindParams.add(arangoQuery.getBindParameters());
        });
        ArrayList<AqlNode> aqlNodes = new ArrayList<AqlNode>();
        aqlNodes.add(getDocumentLine);
        aqlNodes.add(searchOptions.getAqlNode());
        aqlNodes.addAll(subQueryStatements);
        Set set = Arrays.stream(returnTypes).collect(Collectors.toSet());
        if (set.contains(GraphLoaderReturnType.SORT_OPTION)) {
            if (this.arangoNodeKeptAttributesBuilder.isExactlyOneAttributeSet()) {
                aqlNodes.add(new AqlReturn(this.arangoNodeKeptAttributesBuilder.buildOneAttributeFirstValue()));
            } else {
                aqlNodes.add(new AqlReturn(new AqlVariable(this.subQueryBuilders.keySet().iterator().next())));
            }
        } else if (set.contains(GraphLoaderReturnType.FILTER_OPTION)) {
            if (this.arangoNodeKeptAttributesBuilder.isExactlyOneAttributeSet()) {
                aqlNodes.add(new AqlReturn(this.arangoNodeKeptAttributesBuilder.buildOneListOrLeafAttribute()));
            } else {
                Map.Entry<String, ArangoGraphTraversalSubQueryBuilder> graphTraversalBuilderEntry = this.subQueryBuilders.entrySet().iterator().next();
                boolean isList = this.structureSchemaFinder.isList(this.graphElementType, graphTraversalBuilderEntry.getValue().getEdgeType());
                AqlVariable subQueryVariable = new AqlVariable(graphTraversalBuilderEntry.getKey());
                if (!isList) {
                    aqlNodes.add(new AqlReturn(subQueryVariable).getItem(0));
                } else {
                    aqlNodes.add(new AqlReturn(subQueryVariable));
                }
            }
        } else {
            aqlNodes.add(this.createReturnStatement(graph, mappedObject.getAqlNode(), returnTypes));
        }
        AqlRootNode forQuery = new AqlRootNode(aqlNodes);
        Map<String, Object> bindParameters = this.mergeBindParameters(keptAttributes.getBindParameters(), mappedObject.getBindParameters(), searchOptions.getBindParameters());
        subQueryBindParams.forEach(bindParameters::putAll);
        return new ArangoQuery(forQuery, bindParameters);
    }

    private void mapGraphTraversalJoin(AbstractEdgeDescription edgeDescription, String connectionFieldName, AqlVariable subQueryVariable) {
        String edgeType = ((EdgeDescriptionParameters)edgeDescription.getParameters()).getEdgeType();
        FieldDefinition fieldDefinition = this.structureSchemaFinder.getFieldDefinitionOrFallback(this.graphElementType, edgeType);
        if (!fieldDefinition.isList()) {
            this.arangoMappedObjectBuilder.mapCustomField(connectionFieldName, subQueryVariable.getItem(0).getField("data"));
        } else {
            this.arangoMappedObjectBuilder.mapCustomField(connectionFieldName, subQueryVariable.getAllItems().getField("data"));
        }
    }

    private AqlNode createEdges() {
        ArrayList<AqlNode> unionList = new ArrayList<AqlNode>();
        this.subQueryBuilders.keySet().forEach(key -> unionList.add(this.getChildSubQueryEdges(new AqlVariable((String)key))));
        if (this.subQueryBuilders.size() > 1) {
            return new AqlUnion(unionList);
        }
        if (this.subQueryBuilders.size() == 1) {
            return unionList.get(0);
        }
        return new AqlList(new AqlNode[0]);
    }

    private AqlNode createNodes(ArangoQuery keptAttributes) {
        AqlList mainElementList = new AqlList(keptAttributes.getAqlNode());
        if (this.subQueryBuilders.size() > 0) {
            ArrayList unionList = new ArrayList();
            this.subQueryBuilders.keySet().forEach(key -> unionList.add(this.getChildSubQueryNodes(new AqlVariable((String)key))));
            ArrayList<AqlNode> finalList = new ArrayList<AqlNode>(List.of(mainElementList));
            finalList.addAll(unionList);
            return new AqlUnion(finalList);
        }
        return mainElementList;
    }

    private AqlNode createNodes() {
        ArrayList<AqlNode> unionList = new ArrayList<AqlNode>();
        this.subQueryBuilders.keySet().forEach(key -> unionList.add(this.getChildSubQueryNodes(new AqlVariable((String)key))));
        if (this.subQueryBuilders.size() > 1) {
            return new AqlUnion(unionList);
        }
        if (this.subQueryBuilders.size() == 1) {
            return unionList.get(0);
        }
        return new AqlList(new AqlNode[0]);
    }

    private String getChildSubQueryPostfix() {
        return this.createChildSubQueryPostfix(this.subQueryPostfix, this.subQueryBuilders.size());
    }
}

