/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.arangograph.graphLoader.arangoQuery.builder;

import ai.stapi.arangograph.graphLoader.arangoQuery.ArangoQuery;
import ai.stapi.arangograph.graphLoader.arangoQuery.ast.AqlVariable;
import ai.stapi.arangograph.graphLoader.arangoQuery.builder.ArangoGraphTraversalNodeOptionBuilder;
import ai.stapi.arangograph.graphLoader.arangoQuery.builder.ArangoNodeGetSubQueryBuilder;
import ai.stapi.arangograph.graphLoader.arangoQuery.builder.ArangoNodeKeptAttributesBuilder;
import ai.stapi.arangograph.graphLoader.arangoQuery.builder.ArangoSubQueryBuilder;
import ai.stapi.arangograph.graphLoader.arangoQuery.searchOptionResolvers.ArangoGenericSearchOptionResolver;
import ai.stapi.graphoperations.graphLoader.GraphLoaderReturnType;
import ai.stapi.schema.structureSchemaProvider.StructureSchemaFinder;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ArangoQueryByNodeTypeBuilder
implements ArangoSubQueryBuilder {
    private final ArangoGenericSearchOptionResolver searchOptionResolver;
    private final StructureSchemaFinder structureSchemaFinder;
    private final String subQueryPostfix;
    private final AqlVariable nodeDocumentVariableName;
    private final Map<String, Object> nodeOptionsPlaceholders;
    private final Map<String, ArangoSubQueryBuilder> subQueryBuilders;
    private final Map<String, Object> bindParameters;
    private boolean isUsedAsGraphTraversal = false;

    public ArangoQueryByNodeTypeBuilder(ArangoGenericSearchOptionResolver searchOptionResolver, StructureSchemaFinder structureSchemaFinder, String subQueryPostfix, AqlVariable nodeDocumentVariableName) {
        this.searchOptionResolver = searchOptionResolver;
        this.structureSchemaFinder = structureSchemaFinder;
        this.subQueryPostfix = subQueryPostfix;
        this.nodeDocumentVariableName = nodeDocumentVariableName;
        this.nodeOptionsPlaceholders = new HashMap<String, Object>();
        this.subQueryBuilders = new HashMap<String, ArangoSubQueryBuilder>();
        this.bindParameters = new HashMap<String, Object>();
    }

    public static ArangoQueryByNodeTypeBuilder asGraphTraversal(ArangoGenericSearchOptionResolver searchOptionResolver, StructureSchemaFinder structureSchemaFinder, String subQueryPostfix, AqlVariable nodeDocumentVariableName) {
        ArangoQueryByNodeTypeBuilder builder = new ArangoQueryByNodeTypeBuilder(searchOptionResolver, structureSchemaFinder, subQueryPostfix, nodeDocumentVariableName);
        builder.isUsedAsGraphTraversal = true;
        return builder;
    }

    public ArangoNodeGetSubQueryBuilder addGetNodeOption(String nodeType) {
        String nodeTypePlaceholder = this.buildJoinedNodeTypePlaceholder();
        ArangoNodeGetSubQueryBuilder nodeGetSubQueryBuilder = new ArangoNodeGetSubQueryBuilder(this.searchOptionResolver, this.structureSchemaFinder, nodeType, this.getChildSubQueryPostfix(), this.nodeDocumentVariableName);
        String subQueryVariableName = this.buildJoinedNodeSubQueryVariableName();
        this.subQueryBuilders.put(subQueryVariableName, nodeGetSubQueryBuilder);
        this.nodeOptionsPlaceholders.put(nodeTypePlaceholder, subQueryVariableName);
        this.bindParameters.put(nodeTypePlaceholder, nodeType);
        return nodeGetSubQueryBuilder;
    }

    public ArangoGraphTraversalNodeOptionBuilder addGraphTraversalNodeOption(String nodeType) {
        String nodeTypePlaceholder = this.buildJoinedNodeTypePlaceholder();
        ArangoGraphTraversalNodeOptionBuilder nodeOptionBuilder = new ArangoGraphTraversalNodeOptionBuilder(this.structureSchemaFinder, this.searchOptionResolver, nodeType, this.subQueryPostfix, this.nodeDocumentVariableName);
        String subQueryVariableName = this.buildJoinedNodeSubQueryVariableName();
        this.subQueryBuilders.put(subQueryVariableName, nodeOptionBuilder);
        this.nodeOptionsPlaceholders.put(nodeTypePlaceholder, subQueryVariableName);
        this.bindParameters.put(nodeTypePlaceholder, nodeType);
        return nodeOptionBuilder;
    }

    @Override
    public ArangoQuery build(GraphLoaderReturnType ... returnTypes) {
        Map<String, ArangoQuery> buildSubQueries = this.buildSubQueries(returnTypes);
        HashMap<String, Object> finalBindParameters = new HashMap<String, Object>(this.bindParameters);
        buildSubQueries.values().forEach(query -> finalBindParameters.putAll(query.getBindParameters()));
        return new ArangoQuery(new AqlVariable(this.buildString(buildSubQueries, returnTypes)), finalBindParameters);
    }

    private String buildString(Map<String, ArangoQuery> subQueries, GraphLoaderReturnType ... returnTypes) {
        List subQueriesStrings = this.nodeOptionsPlaceholders.entrySet().stream().map(entry -> {
            String actualNodeTypeStatement = this.isUsedAsGraphTraversal ? String.format("PARSE_IDENTIFIER(%s._id).collection", this.nodeDocumentVariableName.getVariableName()) : String.format("PARSE_IDENTIFIER(%s).collection", this.nodeDocumentVariableName.getVariableName());
            String subQueryString = ((ArangoQuery)subQueries.get(entry.getValue())).getQueryString();
            return String.format("%s == @%s ? ( %s )", actualNodeTypeStatement, entry.getKey(), subQueryString);
        }).collect(Collectors.toList());
        subQueriesStrings.add(this.getDefaultValueIfNodeTypeNotPresent(returnTypes));
        return String.join((CharSequence)" : ", subQueriesStrings);
    }

    private Map<String, ArangoQuery> buildSubQueries(GraphLoaderReturnType ... returnTypes) {
        return this.subQueryBuilders.entrySet().stream().map(entry -> new AbstractMap.SimpleEntry<String, ArangoQuery>((String)entry.getKey(), ((ArangoSubQueryBuilder)entry.getValue()).build(returnTypes))).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    }

    private String buildJoinedNodeTypePlaceholder() {
        String basePlaceholder = "joinedNodeCollection_" + this.nodeOptionsPlaceholders.size();
        return this.subQueryPostfix.isBlank() ? basePlaceholder : basePlaceholder + "__" + this.subQueryPostfix;
    }

    private String buildJoinedNodeSubQueryVariableName() {
        return "subQuery_" + this.getChildSubQueryPostfix();
    }

    private String getChildSubQueryPostfix() {
        if (this.subQueryPostfix.isBlank()) {
            return "" + this.subQueryBuilders.size();
        }
        return this.subQueryPostfix + "_" + this.subQueryBuilders.size();
    }

    private String getDefaultValueIfNodeTypeNotPresent(GraphLoaderReturnType ... returnTypes) {
        Set set = Arrays.stream(returnTypes).collect(Collectors.toSet());
        if (set.contains(GraphLoaderReturnType.SORT_OPTION) || set.contains(GraphLoaderReturnType.FILTER_OPTION)) {
            return "( RETURN null )";
        }
        if (this.isUsedAsGraphTraversal) {
            return String.format("( RETURN { graphResponse: { nodes: [ %s ], edges: [] }, data: {} } )", new ArangoNodeKeptAttributesBuilder(this.structureSchemaFinder, this.nodeDocumentVariableName, this.getChildSubQueryPostfix(), "").build().getQueryString());
        }
        return String.format("( %s )", new ArangoNodeGetSubQueryBuilder(this.searchOptionResolver, this.structureSchemaFinder, "", this.getChildSubQueryPostfix(), this.nodeDocumentVariableName).build(GraphLoaderReturnType.GRAPH).getQueryString());
    }
}

