/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.arangograph.graphLoader.arangoQuery.builder;

import ai.stapi.arangograph.graphLoader.arangoQuery.ArangoQuery;
import ai.stapi.arangograph.graphLoader.arangoQuery.ast.AqlNode;
import ai.stapi.arangograph.graphLoader.arangoQuery.ast.AqlObject;
import ai.stapi.arangograph.graphLoader.arangoQuery.ast.AqlString;
import ai.stapi.arangograph.graphLoader.arangoQuery.ast.AqlVariable;
import ai.stapi.arangograph.graphLoader.arangoQuery.ast.highLevelOperations.AqlReturn;
import ai.stapi.graphoperations.graphLoader.GraphLoaderReturnType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public interface ArangoSubQueryBuilder {
    public static final String NODE_DOCUMENT_BASE_NAME = "nodeElement";
    public static final String EDGE_DOCUMENT_BASE_NAME = "edgeElement";
    public static final String BASE_SUB_QUERY_VARIABLE_NAME = "subQuery";
    public static final String NODES = "nodes";
    public static final String EDGES = "edges";
    public static final String GRAPH_RESPONSE = "graphResponse";
    public static final String DATA = "data";

    public ArangoQuery build(GraphLoaderReturnType ... var1);

    default public String createChildSubQueryPostfix(String subQueryPostfix, Integer index) {
        if (subQueryPostfix.isBlank()) {
            return "" + index;
        }
        return subQueryPostfix + "_" + index;
    }

    default public AqlVariable createEdgeDocumentName(String subQueryPostfix) {
        if (subQueryPostfix.isBlank()) {
            return new AqlVariable(EDGE_DOCUMENT_BASE_NAME);
        }
        return new AqlVariable("edgeElement_" + subQueryPostfix);
    }

    default public AqlVariable createNodeDocumentName(String subQueryPostfix) {
        if (subQueryPostfix.isBlank()) {
            return new AqlVariable(NODE_DOCUMENT_BASE_NAME);
        }
        return new AqlVariable("nodeElement_" + subQueryPostfix);
    }

    default public AqlVariable createSubQueryVariable(String subQueryPostfix) {
        if (subQueryPostfix.isBlank()) {
            return new AqlVariable(BASE_SUB_QUERY_VARIABLE_NAME);
        }
        return new AqlVariable(String.format("%s_%s", BASE_SUB_QUERY_VARIABLE_NAME, subQueryPostfix));
    }

    default public AqlObject createGraphObject(AqlNode nodes, AqlNode edges) {
        return new AqlObject(Map.of(new AqlString(NODES), nodes, new AqlString(EDGES), edges));
    }

    default public AqlReturn createReturnStatement(AqlNode graph, AqlNode data, GraphLoaderReturnType ... returnTypes) {
        Set set = Arrays.stream(returnTypes).collect(Collectors.toSet());
        return new AqlReturn(new AqlObject(Map.of(new AqlString(GRAPH_RESPONSE), set.contains(GraphLoaderReturnType.GRAPH) ? graph : new AqlObject(Map.of()), new AqlString(DATA), set.contains(GraphLoaderReturnType.OBJECT) ? data : new AqlObject(Map.of()))));
    }

    default public AqlVariable getChildSubQueryEdges(AqlVariable subQueryVariable) {
        return subQueryVariable.getAllItems().getField(GRAPH_RESPONSE).getField(EDGES).getFlattenItems();
    }

    default public AqlVariable getChildSubQueryNodes(AqlVariable subQueryVariable) {
        return subQueryVariable.getAllItems().getField(GRAPH_RESPONSE).getField(NODES).getFlattenItems();
    }

    default public Map<String, Object> mergeBindParameters(Map<String, Object> ... bindParameters) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Arrays.stream(bindParameters).forEach(result::putAll);
        return result;
    }

    default public AqlVariable createCollectionVariable(String subQueryPostfix) {
        if (subQueryPostfix.isBlank()) {
            return new AqlVariable("collection");
        }
        return new AqlVariable("collection_" + subQueryPostfix);
    }

    default public AqlVariable createIdVariable(String subQueryPostfix) {
        if (subQueryPostfix.isBlank()) {
            return new AqlVariable("graphElementIdPlaceholder");
        }
        return new AqlVariable("graphElementIdPlaceholder" + subQueryPostfix);
    }

    default public AqlObject createConnectionObject(AqlNode edge) {
        return new AqlObject(Map.of(new AqlString(EDGES), edge));
    }
}

