/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.arangograph.graphLoader.arangoQuery.searchOptionResolvers;

import ai.stapi.arangograph.graphLoader.arangoQuery.ArangoQuery;
import ai.stapi.arangograph.graphLoader.arangoQuery.ast.AqlNode;
import ai.stapi.arangograph.graphLoader.arangoQuery.ast.AqlOperator;
import ai.stapi.arangograph.graphLoader.arangoQuery.ast.AqlOperatorStatement;
import ai.stapi.arangograph.graphLoader.arangoQuery.ast.AqlRootNode;
import ai.stapi.arangograph.graphLoader.arangoQuery.ast.highLevelOperations.AqlParentheses;
import ai.stapi.arangograph.graphLoader.arangoQuery.ast.highLevelOperations.AqlQuestionMarkOperator;
import ai.stapi.arangograph.graphLoader.arangoQuery.builder.ArangoSearchResolvingContext;
import ai.stapi.arangograph.graphLoader.arangoQuery.searchOptionResolvers.AbstractArangoCompositeFilterOptionResolver;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.query.CollectionComparisonOperator;
import ai.stapi.graphoperations.graphLoader.search.GenericSearchOptionResolver;
import ai.stapi.graphoperations.graphLoader.search.SearchOption;
import ai.stapi.graphoperations.graphLoader.search.SearchResolvingContext;
import ai.stapi.graphoperations.graphLoader.search.filterOption.NoneMatchFilterOption;
import ai.stapi.schema.structureSchemaProvider.StructureSchemaFinder;
import java.util.HashMap;
import java.util.Objects;

public class ArangoNoneMatchFilterOptionResolver
extends AbstractArangoCompositeFilterOptionResolver<NoneMatchFilterOption> {
    public ArangoNoneMatchFilterOptionResolver(StructureSchemaFinder structureSchemaFinder, GenericSearchOptionResolver<ArangoQuery> genericFilterOptionResolver) {
        super(structureSchemaFinder, genericFilterOptionResolver);
    }

    public boolean supports(SearchOption<?> option) {
        return option instanceof NoneMatchFilterOption;
    }

    @Override
    protected ArangoQuery postProcessResolvedFilter(ArangoQuery resolvedFilter, ArangoSearchResolvingContext context) {
        ArangoQuery resolvedFilterWithParentheses = super.postProcessResolvedFilter(resolvedFilter, context);
        AqlParentheses parentheses = (AqlParentheses)resolvedFilterWithParentheses.getAqlNode();
        AqlNode aqlNode = parentheses.getAqlNode();
        if (aqlNode instanceof AqlOperatorStatement) {
            AqlOperatorStatement operatorStatement = (AqlOperatorStatement)aqlNode;
            AqlOperator operator = operatorStatement.getOperator();
            AqlNode rightExpression = operatorStatement.getRightExpression();
            AqlNode operatorAndRightHand = this.getOperatorAndRightHand(operator, rightExpression, CollectionComparisonOperator.NONE);
            return new ArangoQuery(new AqlParentheses(new AqlRootNode(operatorStatement.getLeftExpression(), operatorAndRightHand)), resolvedFilterWithParentheses.getBindParameters());
        }
        AqlRootNode rootNode = (AqlRootNode)parentheses.getAqlNode();
        AqlQuestionMarkOperator questionMarkOperator = rootNode.getAqlNodeList().stream().filter(AqlQuestionMarkOperator.class::isInstance).map(AqlQuestionMarkOperator.class::cast).findFirst().orElseThrow();
        AqlRootNode oldRightHand = (AqlRootNode)questionMarkOperator.getDeepestRightHandExpression();
        AqlNode operatorAndRightHand = this.getOperatorAndRightHand((AqlOperator)Objects.requireNonNull(oldRightHand).getAqlNodeList().get(0), oldRightHand.getAqlNodeList().get(1), CollectionComparisonOperator.NONE);
        questionMarkOperator.setRightHandExpression(operatorAndRightHand);
        return resolvedFilterWithParentheses;
    }

    protected SearchResolvingContext createLeafChildContext(ArangoSearchResolvingContext parentContext, Integer leafIndex) {
        return new ArangoSearchResolvingContext(parentContext.getDocumentName(), parentContext.getOriginQueryType(), parentContext.getGraphElementType(), "allMatch_" + parentContext.getPlaceholderPostfix() + leafIndex, parentContext.getSubQueryPostfix());
    }

    protected SearchResolvingContext createCompositeChildContext(ArangoSearchResolvingContext parentContext) {
        return new ArangoSearchResolvingContext(parentContext.getDocumentName(), parentContext.getOriginQueryType(), parentContext.getGraphElementType(), "allMatch_" + parentContext.getPlaceholderPostfix(), parentContext.getSubQueryPostfix());
    }

    protected ArangoQuery reduceChildResolvedFilters(ArangoQuery reduced, ArangoQuery childResolvedFilter) {
        HashMap<String, Object> mergedBindParam = new HashMap<String, Object>();
        mergedBindParam.putAll(reduced.getBindParameters());
        mergedBindParam.putAll(childResolvedFilter.getBindParameters());
        return reduced;
    }
}

