/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.axonsystemplugin.fixtures;

import ai.stapi.axonsystemplugin.DefaultGraphProjection;
import ai.stapi.axonsystemplugin.fixtures.GenerateFixtures;
import java.time.Duration;
import java.time.temporal.Temporal;
import java.util.List;
import org.axonframework.commandhandling.gateway.CommandGateway;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ApplicationContext;

public class GenerateFixturesCommandLineRunner
implements CommandLineRunner {
    private final CommandGateway commandGateway;
    private final DefaultGraphProjection graphProjection;
    private final ApplicationContext applicationContext;
    private final Logger logger;

    public GenerateFixturesCommandLineRunner(CommandGateway commandGateway, DefaultGraphProjection graphProjection, ApplicationContext applicationContext) {
        this.commandGateway = commandGateway;
        this.graphProjection = graphProjection;
        this.applicationContext = applicationContext;
        this.logger = LoggerFactory.getLogger(GenerateFixturesCommandLineRunner.class);
    }

    public void run(String ... args) throws Exception {
        this.logger.info("Going to synchronize structure fixtures");
        this.generate(Float.MIN_VALUE, Float.MAX_VALUE, args);
        int exitCode = SpringApplication.exit((ApplicationContext)this.applicationContext, (ExitCodeGenerator[])new ExitCodeGenerator[]{() -> 0});
        System.exit(exitCode);
    }

    private void generate(float minPriority, float maxPriority, String[] args) {
        GenerateFixtures command = new GenerateFixtures(List.of(args), minPriority, maxPriority);
        this.logger.info("Sending generate fixtures command");
        this.commandGateway.send((Object)command);
        Temporal lastEventTime = this.graphProjection.getLastEventTime();
        while (true) {
            try {
                Thread.sleep(15000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            Temporal newTime = this.graphProjection.getLastEventTime();
            if (Duration.between(lastEventTime, newTime).getSeconds() == 0L) {
                return;
            }
            lastEventTime = newTime;
        }
    }
}

