/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.axonsystemplugin.fixtures;

import ai.stapi.graphsystem.messaging.command.AbstractCommand;
import ai.stapi.identity.UniqueIdentifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class GenerateFixtures
extends AbstractCommand<UniqueIdentifier> {
    public static final String SERIALIZATION_TYPE = "GenerateFixtures";
    public static final String TARGET_IDENTIFIER = "Fixtures";
    private List<String> fixtureTags;
    private float minPriority = 0.0f;
    private float maxPriority = 1000000.0f;

    private GenerateFixtures() {
        super(new UniqueIdentifier(TARGET_IDENTIFIER), SERIALIZATION_TYPE);
    }

    public GenerateFixtures(String ... fixtureTags) {
        super(new UniqueIdentifier(TARGET_IDENTIFIER), SERIALIZATION_TYPE);
        this.fixtureTags = Arrays.stream(fixtureTags).collect(Collectors.toList());
    }

    public GenerateFixtures(List<String> fixtureTags, float minPriority, float maxPriority) {
        super(new UniqueIdentifier(TARGET_IDENTIFIER), SERIALIZATION_TYPE);
        this.fixtureTags = new ArrayList<String>(fixtureTags);
        this.minPriority = minPriority;
        this.maxPriority = maxPriority;
    }

    public List<String> getFixtureTags() {
        return this.fixtureTags;
    }

    public float getMinPriority() {
        return this.minPriority;
    }

    public float getMaxPriority() {
        return this.maxPriority;
    }
}

