/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.axonsystemplugin.structuredefinition.configure;

import ai.stapi.axonsystem.dynamic.event.DynamicEventHandler;
import ai.stapi.axonsystemplugin.structuredefinition.configure.ConfigureElementsToStructureDefinition;
import ai.stapi.axonsystemplugin.structuredefinition.configure.ConfigureStructureDefinition;
import ai.stapi.graph.inMemoryGraph.InMemoryGraphRepository;
import ai.stapi.graph.traversableGraphElements.TraversableEdge;
import ai.stapi.graph.traversableGraphElements.TraversableNode;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.query.GraphElementQueryDescription;
import ai.stapi.graphoperations.graphLoader.GraphLoaderGetAsObjectOutput;
import ai.stapi.graphoperations.graphLoader.GraphLoaderReturnType;
import ai.stapi.graphoperations.graphLoader.inmemory.InMemoryGraphLoader;
import ai.stapi.graphoperations.graphLoader.inmemory.InMemoryGraphLoaderProvider;
import ai.stapi.graphsystem.messaging.event.AggregateGraphUpdatedEvent;
import ai.stapi.graphsystem.messaging.event.DynamicGraphUpdatedEvent;
import ai.stapi.graphsystem.structuredefinition.command.importStructureDefinitionFromSource.StructureDefinitionImported;
import ai.stapi.graphsystem.structuredefinition.loader.DatabaseStructureDefinitionLoader;
import ai.stapi.identity.UniqueIdentifier;
import ai.stapi.schema.structuredefinition.ElementDefinition;
import ai.stapi.schema.structuredefinition.ElementDefinitionType;
import ai.stapi.schema.structuredefinition.StructureDefinitionData;
import ai.stapi.schema.structuredefinition.StructureDefinitionId;
import java.util.List;
import org.axonframework.commandhandling.gateway.CommandGateway;
import org.axonframework.eventhandling.EventHandler;
import org.jetbrains.annotations.Nullable;

public class ConfigureImportedStructureDefinitionPolicy {
    private final CommandGateway commandGateway;
    private final InMemoryGraphLoaderProvider inMemoryGraphLoaderProvider;

    public ConfigureImportedStructureDefinitionPolicy(CommandGateway commandGateway, InMemoryGraphLoaderProvider inMemoryGraphLoaderProvider) {
        this.commandGateway = commandGateway;
        this.inMemoryGraphLoaderProvider = inMemoryGraphLoaderProvider;
    }

    @EventHandler
    public void on(StructureDefinitionImported event) {
        this.configureStructureDefinition((AggregateGraphUpdatedEvent<? extends UniqueIdentifier>)event);
    }

    @DynamicEventHandler(messageName="StructureDefinitionCreated")
    public void on(DynamicGraphUpdatedEvent event) {
        this.configureStructureDefinition((AggregateGraphUpdatedEvent<? extends UniqueIdentifier>)event);
    }

    private void configureStructureDefinition(AggregateGraphUpdatedEvent<? extends UniqueIdentifier> event) {
        InMemoryGraphLoader loader = this.inMemoryGraphLoaderProvider.provide(event.getSynchronizedGraph());
        GraphLoaderGetAsObjectOutput output = loader.get(event.getIdentity(), (GraphElementQueryDescription)DatabaseStructureDefinitionLoader.STRUCTURE_DEFINITION_GRAPH_DESCRIPTION, StructureDefinitionData.class, new GraphLoaderReturnType[]{GraphLoaderReturnType.OBJECT});
        this.commandGateway.send((Object)new ConfigureStructureDefinition((StructureDefinitionData)output.getData()));
    }

    @DynamicEventHandler(messageName="ElementOnStructureDefinitionDifferentialAdded")
    public void onElementAdded(DynamicGraphUpdatedEvent event) {
        String structureId = event.getIdentity().getId();
        InMemoryGraphRepository graph = event.getSynchronizedGraph().traversable();
        List differentials = graph.loadAllNodes("StructureDefinitionDifferential");
        if (differentials.size() != 1) {
            throw new RuntimeException("This should never happen.");
        }
        TraversableNode differential = (TraversableNode)differentials.get(0);
        List<ElementDefinition> elements = differential.getEdges("element").stream().map(TraversableEdge::getNodeTo).map(node -> new ElementDefinition(this.getAttributeOrNull((TraversableNode)node, "path", (Class)String.class), node.getEdges("type").stream().map(TraversableEdge::getNodeTo).map(typeNode -> new ElementDefinitionType(this.getAttributeOrNull((TraversableNode)typeNode, "code", (Class)String.class), this.getAttributeOrNull((TraversableNode)typeNode, "targetProfile", (Class)List.class))).toList(), this.getAttributeOrNull((TraversableNode)node, "min", (Class)Integer.class), this.getAttributeOrNull((TraversableNode)node, "max", (Class)String.class), this.getAttributeOrNull((TraversableNode)node, "shortDescription", (Class)String.class), this.getAttributeOrNull((TraversableNode)node, "definition", (Class)String.class), this.getAttributeOrNull((TraversableNode)node, "comment", (Class)String.class))).toList();
        this.commandGateway.send((Object)new ConfigureElementsToStructureDefinition(new StructureDefinitionId(structureId), elements));
    }

    @Nullable
    private <T> T getAttributeOrNull(TraversableNode node, String attributeName, Class<T> clazz) {
        if (!node.hasAttribute(attributeName)) {
            return null;
        }
        return (T)node.getAttribute(attributeName).getValue();
    }
}

