/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.axonsystemplugin.commandpersisting;

import ai.stapi.axonsystem.commandpersisting.CommandFixturesCommitted;
import ai.stapi.axonsystem.commandpersisting.CommandMessageStore;
import ai.stapi.axonsystem.commandpersisting.CommitCommandFixtures;
import ai.stapi.axonsystem.commandpersisting.PersistedCommandMessage;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.axonframework.commandhandling.CommandHandler;
import org.axonframework.eventhandling.gateway.EventGateway;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommitCommandFixturesHandler {
    private final SimpleDateFormat fileDateFormat = new SimpleDateFormat("yyMMddHHmmss");
    private final CommandMessageStore commandMessageStore;
    private final EventGateway eventGateway;
    private final ObjectMapper objectMapper;
    private final Logger logger;

    public CommitCommandFixturesHandler(CommandMessageStore commandMessageStore, EventGateway eventGateway, ObjectMapper objectMapper) {
        this.commandMessageStore = commandMessageStore;
        this.eventGateway = eventGateway;
        this.objectMapper = objectMapper;
        this.logger = LoggerFactory.getLogger(CommitCommandFixturesHandler.class);
    }

    @CommandHandler
    public void handle(CommitCommandFixtures command) throws IOException {
        List messages = this.commandMessageStore.getAll();
        HashMap messagesByName = new HashMap();
        messages.forEach(message -> {
            String commandName = message.getCommandName();
            if (!messagesByName.containsKey(commandName)) {
                messagesByName.put(commandName, new ArrayList());
            }
            ((List)messagesByName.get(commandName)).add(message);
        });
        for (Map.Entry entry : messagesByName.entrySet()) {
            String commandName = (String)entry.getKey();
            String directoryPath = command.getOutputDirectoryPath() + File.separator + commandName;
            File directory = new File(directoryPath);
            if (!directory.exists()) {
                directory.mkdirs();
            }
            List messagesOfName = (List)entry.getValue();
            for (PersistedCommandMessage message2 : messagesOfName) {
                Map commandMetaData;
                String commandId = message2.getTargetAggregateIdentifier();
                Optional<Date> date = this.getDispatchedAtDate(commandName, commandId, commandMetaData = message2.getCommandMetaData());
                if (date.isEmpty()) continue;
                String fileName = this.createFileName(commandId, date.get());
                String filePath = directoryPath + File.separator + fileName;
                int count = 1;
                while (new File(filePath).exists()) {
                    fileName = this.createFileName(commandId + "_" + count, date.get());
                    filePath = directoryPath + File.separator + fileName;
                    ++count;
                }
                try (FileWriter writer = new FileWriter(filePath);){
                    writer.write(this.objectMapper.writeValueAsString(message2.getCommandPayload()));
                }
            }
        }
        this.eventGateway.publish(new Object[]{new CommandFixturesCommitted()});
    }

    @NotNull
    private String createFileName(String commandId, Date date) {
        String dateString = this.fileDateFormat.format(date);
        return dateString + "." + commandId + ".profile.custom.json";
    }

    private Optional<Date> getDispatchedAtDate(String commandName, String commandId, Map<String, Object> commandMetaData) {
        String dispatchedAtMetadataKey = "dispatchedAt";
        Object dispatchedAt = commandMetaData.get(dispatchedAtMetadataKey);
        if (dispatchedAt instanceof String) {
            String dispatchedAtString = (String)dispatchedAt;
            try {
                Timestamp timestamp = Timestamp.valueOf(dispatchedAtString);
                return Optional.of(new Date(timestamp.getTime()));
            }
            catch (IllegalArgumentException e) {
                this.logWarning(commandName, commandId, "it could parse metaData value at key: " + dispatchedAtMetadataKey, e);
            }
        }
        this.logWarning(commandName, commandId, "it does not contain " + dispatchedAtMetadataKey + " field in metaData.");
        return Optional.empty();
    }

    private void logWarning(String commandName, String commandId, String becauseMessage) {
        String message = this.formatLogMessage(commandName, commandId, becauseMessage);
        this.logger.warn(message);
    }

    private void logWarning(String commandName, String commandId, String becauseMessage, Exception cause) {
        String message = this.formatLogMessage(commandName, commandId, becauseMessage);
        this.logger.warn(message, (Throwable)cause);
    }

    private String formatLogMessage(String commandName, String commandId, String becauseMessage) {
        return String.format("Persisted Command Message of type: '%s' with id: '%s' could not committed, because %s", commandName, commandId, becauseMessage);
    }
}

