/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.axonsystemplugin.commandpersisting;

import ai.stapi.axonsystem.commandpersisting.CommitCommandFixtures;
import java.util.Arrays;
import java.util.Optional;
import org.axonframework.commandhandling.gateway.CommandGateway;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ApplicationContext;

public class CommitCommandFixturesLineRunner
implements CommandLineRunner {
    private final CommandGateway commandGateway;
    private final ApplicationContext applicationContext;

    public CommitCommandFixturesLineRunner(CommandGateway commandGateway, ApplicationContext applicationContext) {
        this.commandGateway = commandGateway;
        this.applicationContext = applicationContext;
    }

    public void run(String ... args) {
        String outputDirectoryPath = CommitCommandFixturesLineRunner.getOutputDirectoryPath(args);
        this.commandGateway.sendAndWait((Object)new CommitCommandFixtures(outputDirectoryPath));
        int exitCode = SpringApplication.exit((ApplicationContext)this.applicationContext, (ExitCodeGenerator[])new ExitCodeGenerator[]{() -> 0});
        System.exit(exitCode);
    }

    public static String getOutputDirectoryPath(String ... args) {
        if (args.length == 0) {
            throw new RuntimeException("Please specify path where to commit persisted commands as command line argument.");
        }
        Optional<String> path = Arrays.stream(args).filter(arg -> arg.startsWith("_outputPath:")).map(arg -> arg.replace("_outputPath:", "")).findFirst();
        return path.orElse(args[0]);
    }
}

