/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.axonsystemplugin.structuredefinition.configure;

import ai.stapi.axonsystemplugin.structuredefinition.configure.ConfigureElementsToStructureDefinition;
import ai.stapi.axonsystemplugin.structuredefinition.configure.ConfigureStructureDefinition;
import ai.stapi.axonsystemplugin.structuredefinition.configure.ElementsToStructureDefinitionConfigured;
import ai.stapi.axonsystemplugin.structuredefinition.configure.StructureDefinitionConfigured;
import ai.stapi.identity.UniqueIdentifier;
import ai.stapi.schema.structureSchema.AbstractStructureType;
import ai.stapi.schema.structureSchemaProvider.StructureSchemaFinder;
import ai.stapi.schema.structureSchemaProvider.StructureSchemaProvider;
import ai.stapi.schema.structuredefinition.ElementDefinition;
import ai.stapi.schema.structuredefinition.StructureDefinitionData;
import ai.stapi.schema.structuredefinition.StructureDefinitionId;
import java.util.List;
import java.util.stream.Collectors;
import org.axonframework.commandhandling.CommandHandler;
import org.axonframework.eventhandling.gateway.EventGateway;

public class ConfigureStructureDefinitionHandler {
    private final EventGateway eventGateway;
    private final StructureSchemaProvider structureSchemaProvider;
    private final StructureSchemaFinder structureSchemaFinder;

    public ConfigureStructureDefinitionHandler(EventGateway eventGateway, StructureSchemaProvider structureSchemaProvider, StructureSchemaFinder structureSchemaFinder) {
        this.eventGateway = eventGateway;
        this.structureSchemaProvider = structureSchemaProvider;
        this.structureSchemaFinder = structureSchemaFinder;
    }

    @CommandHandler
    public void handle(ConfigureStructureDefinition command) {
        StructureDefinitionData structureDefinitionDTO = command.getStructureDefinitionData();
        this.structureSchemaProvider.add(structureDefinitionDTO);
        this.eventGateway.publish(new Object[]{new StructureDefinitionConfigured(new StructureDefinitionId(structureDefinitionDTO.getId()), structureDefinitionDTO.getKind())});
    }

    @CommandHandler
    public void handle(ConfigureElementsToStructureDefinition command) {
        String structureType = command.getStructureDefinitionId().getId();
        AbstractStructureType existingStructure = this.structureSchemaFinder.getStructureType(structureType);
        String parentType = existingStructure.getParent();
        List<ElementDefinition> elementDefinitions = command.getElementDefinitions();
        StructureDefinitionData newStructure = new StructureDefinitionData(existingStructure.getDefinitionType(), null, null, null, existingStructure.getKind(), Boolean.valueOf(existingStructure.isAbstract()), existingStructure.getDefinitionType(), null, parentType == null ? null : new UniqueIdentifier(parentType), elementDefinitions);
        this.structureSchemaProvider.add(newStructure);
        this.eventGateway.publish(new Object[]{new ElementsToStructureDefinitionConfigured(new StructureDefinitionId(structureType), existingStructure.getKind(), elementDefinitions.stream().map(ElementDefinition::getPath).collect(Collectors.toList()))});
    }
}

