/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.axonsystem.dynamic.aggregate;

import ai.stapi.axonsystem.dynamic.aggregate.DynamicAggregate;
import ai.stapi.graphsystem.dynamiccommandprocessor.DynamicCommandProcessor;
import ai.stapi.graphsystem.messaging.command.DynamicCommand;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Optional;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandMessageHandlingMember;
import org.axonframework.messaging.Message;
import org.jetbrains.annotations.NotNull;

public abstract class DynamicCommandMessageHandlerMember
implements CommandMessageHandlingMember<DynamicAggregate> {
    protected final DynamicCommandProcessor dynamicCommandProcessor;
    protected final String aggregateType;
    private final String commandName;

    protected DynamicCommandMessageHandlerMember(DynamicCommandProcessor dynamicCommandProcessor, String aggregateType, String commandName) {
        this.commandName = commandName;
        this.aggregateType = aggregateType;
        this.dynamicCommandProcessor = dynamicCommandProcessor;
    }

    public String commandName() {
        return this.commandName;
    }

    public String routingKey() {
        return "targetIdentifier";
    }

    public Class<?> payloadType() {
        return DynamicCommand.class;
    }

    public boolean canHandle(@NotNull Message<?> message) {
        if (!(message instanceof CommandMessage)) {
            return false;
        }
        CommandMessage commandMessage = (CommandMessage)message;
        Object object = commandMessage.getPayload();
        if (!(object instanceof DynamicCommand)) {
            return false;
        }
        DynamicCommand dynamicCommand = (DynamicCommand)object;
        return dynamicCommand.getSerializationType().equals(this.commandName);
    }

    public boolean canHandleMessageType(@NotNull Class<? extends Message> messageType) {
        return messageType.isAssignableFrom(DynamicCommand.class);
    }

    @Deprecated
    public boolean hasAnnotation(Class<? extends Annotation> annotationType) {
        return false;
    }

    @Deprecated
    public Optional<Map<String, Object>> annotationAttributes(Class<? extends Annotation> annotationType) {
        return Optional.empty();
    }
}

