/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.axonsystem.dynamic.aggregate;

import ai.stapi.axonsystem.dynamic.aggregate.DynamicAggregateConfiguration;
import ai.stapi.axonsystem.dynamic.aggregate.DynamicAggregateConfigurationsProvider;
import ai.stapi.axonsystem.dynamic.aggregate.exceptions.CannotProvideDynamicAggregateConfiguration;
import ai.stapi.schema.structureSchema.exception.StructureSchemaException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.axonframework.config.AggregateConfiguration;
import org.axonframework.config.Configurer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeDynamicAggregateConfigurer {
    private final DynamicAggregateConfigurationsProvider dynamicAggregateConfigurationsProvider;
    private final Configurer configurer;
    private final Map<String, List<String>> failedAddedAggregateDefinitions;
    private final Logger logger;

    public RuntimeDynamicAggregateConfigurer(DynamicAggregateConfigurationsProvider dynamicAggregateConfigurationsProvider, Configurer configurer) {
        this.dynamicAggregateConfigurationsProvider = dynamicAggregateConfigurationsProvider;
        this.configurer = configurer;
        this.logger = LoggerFactory.getLogger(RuntimeDynamicAggregateConfigurer.class);
        this.failedAddedAggregateDefinitions = new HashMap<String, List<String>>();
    }

    public void add(String aggregateType) {
        DynamicAggregateConfiguration aggregateDefinition;
        try {
            aggregateDefinition = this.dynamicAggregateConfigurationsProvider.provide(aggregateType);
        }
        catch (CannotProvideDynamicAggregateConfiguration e) {
            throw new RuntimeException("Cannot Configure Dynamic Aggregate at runtime.", e);
        }
        this.add(aggregateDefinition);
    }

    public void add(DynamicAggregateConfiguration aggregateDefinition) {
        String aggregateType = aggregateDefinition.getAggregateType();
        try {
            aggregateDefinition.setAsAddedAtRuntime();
            this.configurer.configureAggregate((AggregateConfiguration)aggregateDefinition);
            String message = "New aggregate added at runtime: [%s]".formatted(aggregateType);
            this.logger.info(message);
            this.tryToConfigureFailed(aggregateType);
        }
        catch (StructureSchemaException exception) {
            String missingSerializationType = exception.getParentDefinitionType();
            this.addToFailedTypes(aggregateType, missingSerializationType);
        }
    }

    public void tryToConfigureFailed(String successfullyAddedType) {
        if (this.failedAddedAggregateDefinitions.containsKey(successfullyAddedType)) {
            List<String> previouslyFailed = this.failedAddedAggregateDefinitions.get(successfullyAddedType);
            this.failedAddedAggregateDefinitions.put(successfullyAddedType, new ArrayList());
            previouslyFailed.forEach(this::add);
        }
    }

    public Map<String, List<String>> getFailedAddedAggregateDefinitions() {
        return this.failedAddedAggregateDefinitions;
    }

    private void addToFailedTypes(String aggregateType, String missingType) {
        this.failedAddedAggregateDefinitions.computeIfAbsent(missingType, key -> new ArrayList()).add(aggregateType);
    }
}

