/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.axonsystem.dynamic.aggregate;

import ai.stapi.axonsystem.dynamic.aggregate.DynamicAggregate;
import ai.stapi.axonsystem.dynamic.aggregate.DynamicAggregateModel;
import ai.stapi.axonsystem.dynamic.aggregate.DynamicConstructorCommandMessageHandlerMember;
import ai.stapi.axonsystem.dynamic.aggregate.DynamicCreateIfMissingCommandMessageHandlerMember;
import ai.stapi.axonsystem.dynamic.aggregate.DynamicMethodCommandMessageHandlerMember;
import ai.stapi.graphsystem.dynamiccommandprocessor.DynamicCommandProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandMessageHandler;
import org.axonframework.commandhandling.NoHandlerForCommandException;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.Registration;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageHandler;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.MessageHandlingMember;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.modelling.command.Aggregate;
import org.axonframework.modelling.command.AggregateNotFoundException;
import org.axonframework.modelling.command.CommandTargetResolver;
import org.axonframework.modelling.command.Repository;
import org.axonframework.modelling.command.VersionedAggregateIdentifier;

public class DynamicAggregateCommandHandler
implements CommandMessageHandler {
    private final Repository<DynamicAggregate> repository;
    private final CommandTargetResolver commandTargetResolver;
    private final List<MessageHandler<CommandMessage<?>>> handlers;
    private final Set<String> supportedCommandNames;
    private final Map<String, Set<MessageHandler<CommandMessage<?>>>> supportedCommandsByName;
    private final DynamicCommandProcessor dynamicCommandProcessor;
    private final DynamicAggregateModel dynamicAggregateModel;

    public static Builder builder() {
        return new Builder();
    }

    protected DynamicAggregateCommandHandler(Builder builder) {
        builder.validate();
        this.repository = builder.repository;
        this.commandTargetResolver = builder.commandTargetResolver;
        this.supportedCommandNames = new HashSet<String>();
        this.supportedCommandsByName = new HashMap();
        this.dynamicCommandProcessor = builder.dynamicCommandProcessor;
        this.dynamicAggregateModel = builder.buildAggregateModel();
        this.handlers = this.initializeHandlers(this.dynamicAggregateModel);
    }

    public Registration subscribe(CommandBus commandBus) {
        List<Registration> subscriptions = this.supportedCommandsByName.entrySet().stream().flatMap(entry -> ((Set)entry.getValue()).stream().map(messageHandler -> commandBus.subscribe((String)entry.getKey(), messageHandler))).filter(Objects::nonNull).toList();
        return () -> subscriptions.stream().map(Registration::cancel).reduce(Boolean::logicalOr).orElse(false);
    }

    private List<MessageHandler<CommandMessage<?>>> initializeHandlers(DynamicAggregateModel aggregateModel) {
        ArrayList handlersFound = new ArrayList();
        aggregateModel.allCommandHandlers().values().stream().flatMap(Collection::stream).forEach(commandHandler -> this.initializeHandler(aggregateModel, (MessageHandlingMember<? super DynamicAggregate>)commandHandler, handlersFound));
        return handlersFound;
    }

    private void initializeHandler(DynamicAggregateModel dynamicAggregateModel, MessageHandlingMember<? super DynamicAggregate> handler, List<MessageHandler<CommandMessage<?>>> handlersFound) {
        Optional neverHandler;
        Optional createOrUpdate;
        Object messageHandler = null;
        String commandName = null;
        Optional createHandler = handler.unwrap(DynamicConstructorCommandMessageHandlerMember.class);
        if (createHandler.isPresent()) {
            messageHandler = new AggregateConstructorCommandHandler((MessageHandlingMember)createHandler.get());
            commandName = ((DynamicConstructorCommandMessageHandlerMember)createHandler.get()).commandName();
        }
        if ((createOrUpdate = handler.unwrap(DynamicCreateIfMissingCommandMessageHandlerMember.class)).isPresent()) {
            messageHandler = new AggregateCreateOrUpdateCommandHandler((MessageHandlingMember<? super DynamicAggregate>)((MessageHandlingMember)createOrUpdate.get()), this.dynamicCommandProcessor, dynamicAggregateModel.type());
            commandName = ((DynamicCreateIfMissingCommandMessageHandlerMember)createOrUpdate.get()).commandName();
        }
        if ((neverHandler = handler.unwrap(DynamicMethodCommandMessageHandlerMember.class)).isPresent()) {
            messageHandler = new AggregateCommandHandler((MessageHandlingMember<? super DynamicAggregate>)((MessageHandlingMember)neverHandler.get()));
            commandName = ((DynamicMethodCommandMessageHandlerMember)neverHandler.get()).commandName();
        }
        if (messageHandler == null) {
            throw new UnknownDynamicCommandHandlerException("Unknown dynamic command message handling member in aggregate configuration.");
        }
        handlersFound.add((MessageHandler<CommandMessage<?>>)messageHandler);
        this.supportedCommandsByName.computeIfAbsent(commandName, key -> new HashSet()).add(messageHandler);
        this.supportedCommandNames.add(commandName);
    }

    public Object handle(CommandMessage<?> commandMessage) throws Exception {
        return this.handlers.stream().filter(ch -> ch.canHandle((Message)commandMessage)).findFirst().orElseThrow(() -> new NoHandlerForCommandException(commandMessage)).handle(commandMessage);
    }

    public boolean canHandle(CommandMessage<?> message) {
        return this.handlers.stream().anyMatch(ch -> ch.canHandle((Message)message));
    }

    protected Object resolveReturnValue(CommandMessage<?> command, Aggregate<DynamicAggregate> createdAggregate) {
        return createdAggregate.identifier();
    }

    public Set<String> supportedCommandNames() {
        return this.supportedCommandNames;
    }

    public static class Builder {
        private Repository<DynamicAggregate> repository;
        private DynamicCommandProcessor dynamicCommandProcessor;
        private CommandTargetResolver commandTargetResolver;
        private ParameterResolverFactory parameterResolverFactory;
        private HandlerDefinition handlerDefinition;
        private DynamicAggregateModel aggregateModel;

        public Builder repository(Repository<DynamicAggregate> repository) {
            BuilderUtils.assertNonNull(repository, (String)"Repository may not be null");
            this.repository = repository;
            return this;
        }

        public Builder dynamicCommandProcessor(DynamicCommandProcessor dynamicCommandProcessor) {
            BuilderUtils.assertNonNull((Object)dynamicCommandProcessor, (String)"Repository may not be null");
            this.dynamicCommandProcessor = dynamicCommandProcessor;
            return this;
        }

        public Builder commandTargetResolver(CommandTargetResolver commandTargetResolver) {
            BuilderUtils.assertNonNull((Object)commandTargetResolver, (String)"CommandTargetResolver may not be null");
            this.commandTargetResolver = commandTargetResolver;
            return this;
        }

        public Builder parameterResolverFactory(ParameterResolverFactory parameterResolverFactory) {
            BuilderUtils.assertNonNull((Object)parameterResolverFactory, (String)"ParameterResolverFactory may not be null");
            this.parameterResolverFactory = parameterResolverFactory;
            return this;
        }

        public Builder handlerDefinition(HandlerDefinition handlerDefinition) {
            BuilderUtils.assertNonNull((Object)handlerDefinition, (String)"HandlerDefinition may not be null");
            this.handlerDefinition = handlerDefinition;
            return this;
        }

        public Builder aggregateModel(DynamicAggregateModel aggregateModel) {
            BuilderUtils.assertNonNull((Object)aggregateModel, (String)"AggregateModel may not be null");
            this.aggregateModel = aggregateModel;
            return this;
        }

        private DynamicAggregateModel buildAggregateModel() {
            return this.aggregateModel;
        }

        public DynamicAggregateCommandHandler build() {
            return new DynamicAggregateCommandHandler(this);
        }

        protected void validate() throws AxonConfigurationException {
            BuilderUtils.assertNonNull(this.repository, (String)"The Repository is a hard requirement and should be provided");
            BuilderUtils.assertNonNull((Object)this.aggregateModel, (String)"No AggregateModel is set, but it is a hard requirement");
            BuilderUtils.assertNonNull((Object)this.dynamicCommandProcessor, (String)"No Dynamic Command Processor is set, but it is a hard requirement");
        }
    }

    private class AggregateConstructorCommandHandler
    implements MessageHandler<CommandMessage<?>> {
        private final MessageHandlingMember<?> handler;

        public AggregateConstructorCommandHandler(MessageHandlingMember<?> handler) {
            this.handler = handler;
        }

        public Object handle(CommandMessage<?> command) throws Exception {
            Aggregate aggregate = DynamicAggregateCommandHandler.this.repository.newInstance(() -> (DynamicAggregate)this.handler.handle((Message)command, null));
            return DynamicAggregateCommandHandler.this.resolveReturnValue(command, (Aggregate<DynamicAggregate>)aggregate);
        }

        public boolean canHandle(CommandMessage<?> message) {
            return this.handler.canHandle(message);
        }
    }

    private class AggregateCreateOrUpdateCommandHandler
    implements MessageHandler<CommandMessage<?>> {
        private final MessageHandlingMember<? super DynamicAggregate> handler;
        private final DynamicCommandProcessor dynamicCommandProcessor;
        private final String aggregateType;

        public AggregateCreateOrUpdateCommandHandler(MessageHandlingMember<? super DynamicAggregate> handler, DynamicCommandProcessor dynamicCommandProcessor, String aggregateType) {
            this.handler = handler;
            this.dynamicCommandProcessor = dynamicCommandProcessor;
            this.aggregateType = aggregateType;
        }

        public Object handle(CommandMessage<?> command) throws Exception {
            VersionedAggregateIdentifier iv = DynamicAggregateCommandHandler.this.commandTargetResolver.resolveTarget(command);
            return DynamicAggregateCommandHandler.this.repository.loadOrCreate(iv.getIdentifier(), () -> new DynamicAggregate(this.dynamicCommandProcessor, this.aggregateType)).handle(command);
        }

        public boolean canHandle(CommandMessage<?> message) {
            return this.handler.canHandle(message);
        }
    }

    private class AggregateCommandHandler
    implements MessageHandler<CommandMessage<?>> {
        private final MessageHandlingMember<? super DynamicAggregate> handler;

        public AggregateCommandHandler(MessageHandlingMember<? super DynamicAggregate> handler) {
            this.handler = handler;
        }

        public Object handle(CommandMessage<?> command) throws Exception {
            Aggregate aggregate;
            VersionedAggregateIdentifier identifier = DynamicAggregateCommandHandler.this.commandTargetResolver.resolveTarget(command);
            try {
                aggregate = DynamicAggregateCommandHandler.this.repository.load(identifier.getIdentifier(), identifier.getVersion());
            }
            catch (AggregateNotFoundException e) {
                throw new AggregateNotFoundException(identifier.getIdentifier(), String.format("Cannot handle command [%s] in aggregate [%s] with id [%s].%n%s%s", command.getCommandName(), DynamicAggregateCommandHandler.this.dynamicAggregateModel.type(), identifier.getIdentifier(), "Command handler cannot construct new aggregate instance", ", but aggregate with such id was not found."), (Throwable)e);
            }
            return aggregate.handle(command);
        }

        public boolean canHandle(CommandMessage<?> message) {
            return this.handler.canHandle(message);
        }
    }

    private static class UnknownDynamicCommandHandlerException
    extends RuntimeException {
        public UnknownDynamicCommandHandlerException(String message) {
            super(message);
        }

        public UnknownDynamicCommandHandlerException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

