/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.axonsystem.dynamic;

import ai.stapi.axonsystem.dynamic.aggregate.DynamicAggregate;
import ai.stapi.axonsystem.dynamic.aggregate.DynamicAggregateConfiguration;
import ai.stapi.axonsystem.dynamic.aggregate.DynamicAggregateConfigurationsProvider;
import ai.stapi.axonsystem.dynamic.aggregate.RuntimeDynamicAggregateConfigurer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.config.AggregateConfiguration;
import org.axonframework.config.Configuration;
import org.axonframework.config.Configurer;
import org.axonframework.config.EventProcessingConfigurer;
import org.axonframework.config.LifecycleHandler;
import org.axonframework.config.MessageMonitorFactory;
import org.axonframework.config.ModuleConfiguration;
import org.axonframework.config.TagsConfiguration;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventsourcing.Snapshotter;
import org.axonframework.eventsourcing.eventstore.EventStorageEngine;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.HandlerEnhancerDefinition;
import org.axonframework.messaging.correlation.CorrelationDataProvider;
import org.axonframework.modelling.saga.ResourceInjector;
import org.axonframework.monitoring.MessageMonitor;
import org.axonframework.queryhandling.QueryBus;
import org.axonframework.queryhandling.QueryUpdateEmitter;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.upcasting.event.EventUpcaster;
import org.axonframework.spring.config.SpringConfigurer;
import org.jetbrains.annotations.NotNull;

public class DynamicAxonConfigurer
implements Configurer {
    private final SpringConfigurer springConfigurer;
    private final DynamicAggregateConfigurationsProvider dynamicAggregateConfigurationsProvider;
    private final RuntimeDynamicAggregateConfigurer runtimeDynamicAggregateConfigurer;
    private final List<String> configuredAggregates;

    public DynamicAxonConfigurer(SpringConfigurer springConfigurer, DynamicAggregateConfigurationsProvider dynamicAggregateConfigurationsProvider, RuntimeDynamicAggregateConfigurer runtimeDynamicAggregateConfigurer) {
        this.springConfigurer = springConfigurer;
        this.dynamicAggregateConfigurationsProvider = dynamicAggregateConfigurationsProvider;
        this.runtimeDynamicAggregateConfigurer = runtimeDynamicAggregateConfigurer;
        this.configuredAggregates = new ArrayList<String>();
    }

    public Configurer registerEventUpcaster(@NotNull Function<Configuration, EventUpcaster> function) {
        return this.springConfigurer.registerEventUpcaster(function);
    }

    public Configurer configureMessageMonitor(@NotNull Function<Configuration, BiFunction<Class<?>, String, MessageMonitor<Message<?>>>> function) {
        return this.springConfigurer.configureMessageMonitor(function);
    }

    public Configurer configureMessageMonitor(@NotNull Class<?> componentType, @NotNull Function<Configuration, MessageMonitor<Message<?>>> messageMonitorBuilder) {
        return this.springConfigurer.configureMessageMonitor(componentType, messageMonitorBuilder);
    }

    public Configurer configureMessageMonitor(@NotNull Class<?> aClass, @NotNull MessageMonitorFactory messageMonitorFactory) {
        return this.springConfigurer.configureMessageMonitor(aClass, messageMonitorFactory);
    }

    public Configurer configureMessageMonitor(@NotNull Class<?> componentType, @NotNull String componentName, @NotNull Function<Configuration, MessageMonitor<Message<?>>> messageMonitorBuilder) {
        return this.springConfigurer.configureMessageMonitor(componentType, componentName, messageMonitorBuilder);
    }

    public Configurer configureMessageMonitor(@NotNull Class<?> aClass, @NotNull String s, @NotNull MessageMonitorFactory messageMonitorFactory) {
        return this.springConfigurer.configureMessageMonitor(aClass, s, messageMonitorFactory);
    }

    public Configurer configureCorrelationDataProviders(@NotNull Function<Configuration, List<CorrelationDataProvider>> function) {
        return this.springConfigurer.configureCorrelationDataProviders(function);
    }

    public Configurer registerModule(@NotNull ModuleConfiguration moduleConfiguration) {
        return this.springConfigurer.registerModule(moduleConfiguration);
    }

    public <C> Configurer registerComponent(@NotNull Class<C> aClass, @NotNull Function<Configuration, ? extends C> function) {
        return this.springConfigurer.registerComponent(aClass, function);
    }

    public Configurer registerCommandHandler(@NotNull Function<Configuration, Object> function) {
        return this.springConfigurer.registerCommandHandler(function);
    }

    @Deprecated
    public Configurer registerCommandHandler(int phase, @NotNull Function<Configuration, Object> commandHandlerBuilder) {
        return this.springConfigurer.registerCommandHandler(phase, commandHandlerBuilder);
    }

    public Configurer registerQueryHandler(@NotNull Function<Configuration, Object> function) {
        return this.springConfigurer.registerQueryHandler(function);
    }

    @Deprecated
    public Configurer registerQueryHandler(int phase, @NotNull Function<Configuration, Object> queryHandlerBuilder) {
        return this.springConfigurer.registerQueryHandler(phase, queryHandlerBuilder);
    }

    public Configurer registerMessageHandler(@NotNull Function<Configuration, Object> function) {
        return this.springConfigurer.registerMessageHandler(function);
    }

    public Configurer configureEmbeddedEventStore(@NotNull Function<Configuration, EventStorageEngine> function) {
        return this.springConfigurer.configureEmbeddedEventStore(function);
    }

    public Configurer configureEventStore(@NotNull Function<Configuration, EventStore> eventStoreBuilder) {
        return this.springConfigurer.configureEventStore(eventStoreBuilder);
    }

    public Configurer configureEventBus(@NotNull Function<Configuration, EventBus> eventBusBuilder) {
        return this.springConfigurer.configureEventBus(eventBusBuilder);
    }

    public Configurer configureCommandBus(@NotNull Function<Configuration, CommandBus> commandBusBuilder) {
        return this.springConfigurer.configureCommandBus(commandBusBuilder);
    }

    public Configurer configureQueryBus(@NotNull Function<Configuration, QueryBus> queryBusBuilder) {
        return this.springConfigurer.configureQueryBus(queryBusBuilder);
    }

    public Configurer configureQueryUpdateEmitter(@NotNull Function<Configuration, QueryUpdateEmitter> queryUpdateEmitterBuilder) {
        return this.springConfigurer.configureQueryUpdateEmitter(queryUpdateEmitterBuilder);
    }

    public Configurer configureSerializer(@NotNull Function<Configuration, Serializer> serializerBuilder) {
        return this.springConfigurer.configureSerializer(serializerBuilder);
    }

    public Configurer configureEventSerializer(@NotNull Function<Configuration, Serializer> function) {
        return this.springConfigurer.configureEventSerializer(function);
    }

    public Configurer configureMessageSerializer(@NotNull Function<Configuration, Serializer> function) {
        return this.springConfigurer.configureMessageSerializer(function);
    }

    public Configurer configureTransactionManager(@NotNull Function<Configuration, TransactionManager> transactionManagerBuilder) {
        return this.springConfigurer.configureTransactionManager(transactionManagerBuilder);
    }

    public Configurer configureResourceInjector(@NotNull Function<Configuration, ResourceInjector> resourceInjectorBuilder) {
        return this.springConfigurer.configureResourceInjector(resourceInjectorBuilder);
    }

    public Configurer configureTags(@NotNull Function<Configuration, TagsConfiguration> tagsBuilder) {
        return this.springConfigurer.configureTags(tagsBuilder);
    }

    public <A> Configurer configureAggregate(@NotNull AggregateConfiguration<A> aggregateConfiguration) {
        Class aggregateClass = aggregateConfiguration.aggregateType();
        if (aggregateClass.equals(DynamicAggregate.class)) {
            DynamicAggregateConfiguration dynamicConfig = (DynamicAggregateConfiguration)aggregateConfiguration;
            this.configuredAggregates.add(dynamicConfig.getAggregateType());
        } else {
            this.configuredAggregates.add(aggregateClass.getCanonicalName());
        }
        return this.springConfigurer.configureAggregate(aggregateConfiguration);
    }

    public <A> Configurer configureAggregate(@NotNull Class<A> aggregate) {
        return this.springConfigurer.configureAggregate(aggregate);
    }

    public Configurer registerHandlerDefinition(@NotNull BiFunction<Configuration, Class, HandlerDefinition> biFunction) {
        return this.springConfigurer.registerHandlerDefinition(biFunction);
    }

    public Configurer registerHandlerEnhancerDefinition(Function<Configuration, HandlerEnhancerDefinition> handlerEnhancerBuilder) {
        return this.springConfigurer.registerHandlerEnhancerDefinition(handlerEnhancerBuilder);
    }

    public Configurer configureSnapshotter(@NotNull Function<Configuration, Snapshotter> snapshotterBuilder) {
        return this.springConfigurer.configureSnapshotter(snapshotterBuilder);
    }

    public EventProcessingConfigurer eventProcessing() throws AxonConfigurationException {
        return this.springConfigurer.eventProcessing();
    }

    public Configurer eventProcessing(@NotNull Consumer<EventProcessingConfigurer> eventProcessingConfigurer) throws AxonConfigurationException {
        return this.springConfigurer.eventProcessing(eventProcessingConfigurer);
    }

    public Configurer registerEventHandler(@NotNull Function<Configuration, Object> eventHandlerBuilder) {
        return this.springConfigurer.registerEventHandler(eventHandlerBuilder);
    }

    public void onInitialize(@NotNull Consumer<Configuration> initHandler) {
        this.springConfigurer.onInitialize(initHandler);
    }

    public Configuration buildConfiguration() {
        List<DynamicAggregateConfiguration> aggregateConfigurations = this.dynamicAggregateConfigurationsProvider.provide();
        aggregateConfigurations.forEach(this::configureAggregate);
        return this.springConfigurer.buildConfiguration();
    }

    public Configuration start() {
        return this.springConfigurer.start();
    }

    public void onStart(int phase, LifecycleHandler startHandler) {
        this.springConfigurer.onStart(phase, startHandler);
    }

    public void onShutdown(int phase, LifecycleHandler shutdownHandler) {
        this.springConfigurer.onShutdown(phase, shutdownHandler);
    }

    public void configureNewAggregates() {
        List<DynamicAggregateConfiguration> currentConfigs = this.dynamicAggregateConfigurationsProvider.provide();
        currentConfigs.stream().filter(config -> !this.configuredAggregates.contains(config.getAggregateType())).forEach(this.runtimeDynamicAggregateConfigurer::add);
    }
}

