/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.axonsystem.commandvalidation;

import ai.stapi.graphsystem.commandvalidation.model.CommandConstrainViolation;
import ai.stapi.graphsystem.commandvalidation.model.CommandValidator;
import ai.stapi.graphsystem.commandvalidation.model.exceptions.CannotDispatchCommand;
import ai.stapi.graphsystem.messaging.command.Command;
import ai.stapi.graphsystem.messaging.command.DynamicCommand;
import java.util.List;
import java.util.function.BiFunction;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.jetbrains.annotations.NotNull;

public class CommandValidatorDispatchInterceptor
implements MessageDispatchInterceptor<CommandMessage<?>> {
    private final CommandValidator commandValidator;

    public CommandValidatorDispatchInterceptor(CommandValidator commandValidator) {
        this.commandValidator = commandValidator;
    }

    @NotNull
    public BiFunction<Integer, CommandMessage<?>, CommandMessage<?>> handle(@NotNull List<? extends CommandMessage<?>> messages) {
        return (index, commandMessage) -> {
            DynamicCommand command;
            List violations;
            Object payload = commandMessage.getPayload();
            if (!(payload instanceof Command)) {
                throw CannotDispatchCommand.becauseItDoesNotImplementCommandInterface((String)commandMessage.getCommandName(), payload.getClass());
            }
            if (payload instanceof DynamicCommand && this.isThereErrorViolation(violations = this.commandValidator.validate((Command)(command = (DynamicCommand)payload)))) {
                throw CannotDispatchCommand.becauseThereWereConstrainViolation((String)command.getSerializationType(), (String)command.getTargetIdentifier().getId(), (List)violations);
            }
            return commandMessage;
        };
    }

    private boolean isThereErrorViolation(List<CommandConstrainViolation> violations) {
        return violations.stream().anyMatch(violation -> violation.getLevel().equals((Object)CommandConstrainViolation.Level.ERROR));
    }
}

