/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.axonsystem.configuration;

import ai.stapi.axonsystem.commandvalidation.CommandValidatorDispatchInterceptor;
import ai.stapi.axonsystem.configuration.implementations.CommandDispatchedAtInterceptor;
import ai.stapi.axonsystem.configuration.implementations.CustomFailureLoggingCallback;
import ai.stapi.graphsystem.commandvalidation.model.CommandValidator;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.DuplicateCommandHandlerResolver;
import org.axonframework.commandhandling.SimpleCommandBus;
import org.axonframework.commandhandling.gateway.CommandGateway;
import org.axonframework.commandhandling.gateway.DefaultCommandGateway;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.config.Configuration;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.correlation.CorrelationDataProvider;
import org.axonframework.messaging.correlation.MessageOriginProvider;
import org.axonframework.messaging.interceptors.CorrelationDataInterceptor;
import org.axonframework.springboot.autoconfig.AxonAutoConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Profile;

@AutoConfiguration
@AutoConfigureBefore(value={AxonAutoConfiguration.class})
public class CommandGatewayConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={CommandGateway.class})
    public DefaultCommandGateway configuredCommandGateway(@Autowired CommandBus commandBus, @Autowired List<MessageDispatchInterceptor<? super CommandMessage<?>>> messageDispatchInterceptors) {
        CustomFailureLoggingCallback failureCommandCallback = new CustomFailureLoggingCallback(Logger.getLogger(DefaultCommandGateway.class.getSimpleName()));
        return DefaultCommandGateway.builder().commandBus(commandBus).commandCallback(failureCommandCallback).dispatchInterceptors(messageDispatchInterceptors).build();
    }

    @Bean
    @ConditionalOnMissingBean
    public CommandBus configuredCommandBus(@Autowired TransactionManager txManager, @Autowired Configuration axonConfiguration, @Autowired DuplicateCommandHandlerResolver duplicateCommandHandlerResolver, @Autowired List<MessageHandlerInterceptor<? super CommandMessage<?>>> messageHandlerInterceptors) {
        SimpleCommandBus commandBus = SimpleCommandBus.builder().transactionManager(txManager).duplicateCommandHandlerResolver(duplicateCommandHandlerResolver).spanFactory(axonConfiguration.spanFactory()).messageMonitor(axonConfiguration.messageMonitor(CommandBus.class, "commandBus")).build();
        commandBus.registerHandlerInterceptor((MessageHandlerInterceptor)new CorrelationDataInterceptor((Collection)axonConfiguration.correlationDataProviders()));
        messageHandlerInterceptors.forEach(arg_0 -> ((SimpleCommandBus)commandBus).registerHandlerInterceptor(arg_0));
        return commandBus;
    }

    @Bean
    public CommandDispatchedAtInterceptor commandDispatchedAtInterceptor() {
        return new CommandDispatchedAtInterceptor();
    }

    @Bean
    @Profile(value={"dev"})
    public CommandValidatorDispatchInterceptor commandValidatorDispatchInterceptor(CommandValidator commandValidator) {
        return new CommandValidatorDispatchInterceptor(commandValidator);
    }

    @Bean
    public CorrelationDataProvider messageCorrelationProvider() {
        return new MessageOriginProvider();
    }
}

