/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.axonsystem.dynamic.aggregate;

import ai.stapi.axonsystem.dynamic.aggregate.DynamicAggregate;
import ai.stapi.axonsystem.dynamic.aggregate.DynamicAggregateConfiguration;
import ai.stapi.axonsystem.dynamic.aggregate.DynamicAggregateConfigurationsProvider;
import ai.stapi.axonsystem.dynamic.aggregate.DynamicAggregateModel;
import ai.stapi.axonsystem.dynamic.aggregate.DynamicConstructorCommandMessageHandlerMember;
import ai.stapi.axonsystem.dynamic.aggregate.DynamicCreateIfMissingCommandMessageHandlerMember;
import ai.stapi.axonsystem.dynamic.aggregate.DynamicMethodCommandMessageHandlerMember;
import ai.stapi.axonsystem.dynamic.aggregate.exceptions.CannotProvideDynamicAggregateConfiguration;
import ai.stapi.axonsystem.dynamic.aggregate.exceptions.CannotProvideDynamicAggregateConfigurationFromAggregateDefinition;
import ai.stapi.graphsystem.aggregatedefinition.model.AggregateDefinitionDTO;
import ai.stapi.graphsystem.aggregatedefinition.model.AggregateDefinitionProvider;
import ai.stapi.graphsystem.aggregatedefinition.model.exceptions.CannotProvideAggregateDefinition;
import ai.stapi.graphsystem.dynamiccommandprocessor.DynamicCommandProcessor;
import ai.stapi.graphsystem.messaging.event.AggregateGraphUpdatedEvent;
import ai.stapi.graphsystem.messaging.event.GraphUpdatedEvent;
import java.lang.reflect.Executable;
import java.util.List;
import org.axonframework.config.Configuration;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventsourcing.NoSnapshotTriggerDefinition;
import org.axonframework.eventsourcing.SnapshotTriggerDefinition;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.eventsourcing.snapshotting.RevisionSnapshotFilter;
import org.axonframework.eventsourcing.snapshotting.SnapshotFilter;
import org.axonframework.messaging.annotation.AnnotatedMessageHandlingMember;
import org.axonframework.messaging.annotation.MessageHandlingMember;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.modelling.command.CommandTargetResolver;
import org.axonframework.tracing.SpanFactory;
import org.jetbrains.annotations.NotNull;

public class AggregateDefinitionDACProvider
implements DynamicAggregateConfigurationsProvider {
    private final AggregateDefinitionProvider aggregateDefinitionProvider;
    private final DynamicCommandProcessor dynamicCommandProcessor;
    private final EventStore eventStore;
    private final SpanFactory spanFactory;
    private final Configuration configuration;
    private final ParameterResolverFactory parameterResolverFactory;
    private final CommandTargetResolver commandTargetResolver;

    public AggregateDefinitionDACProvider(AggregateDefinitionProvider aggregateDefinitionProvider, DynamicCommandProcessor dynamicCommandProcessor, EventStore eventStore, SpanFactory spanFactory, Configuration configuration, ParameterResolverFactory parameterResolverFactory, CommandTargetResolver commandTargetResolver) {
        this.aggregateDefinitionProvider = aggregateDefinitionProvider;
        this.dynamicCommandProcessor = dynamicCommandProcessor;
        this.eventStore = eventStore;
        this.spanFactory = spanFactory;
        this.configuration = configuration;
        this.parameterResolverFactory = parameterResolverFactory;
        this.commandTargetResolver = commandTargetResolver;
    }

    @Override
    public List<DynamicAggregateConfiguration> provide() {
        List aggregateDefinitions = this.aggregateDefinitionProvider.provideAll();
        return aggregateDefinitions.stream().map(this::createDynamicAggregateConfiguration).toList();
    }

    @Override
    public DynamicAggregateConfiguration provide(String aggregateType) throws CannotProvideDynamicAggregateConfiguration {
        AggregateDefinitionDTO aggregateDefinition;
        try {
            aggregateDefinition = this.aggregateDefinitionProvider.provide(aggregateType);
        }
        catch (CannotProvideAggregateDefinition e) {
            throw new CannotProvideDynamicAggregateConfiguration(aggregateType, e);
        }
        return this.createDynamicAggregateConfiguration(aggregateDefinition);
    }

    @NotNull
    private DynamicAggregateConfiguration createDynamicAggregateConfiguration(AggregateDefinitionDTO definition) {
        String aggregateType = definition.getName();
        DynamicAggregateModel.Builder modelBuilder = new DynamicAggregateModel.Builder(aggregateType);
        modelBuilder.addEventHandler((MessageHandlingMember<? super DynamicAggregate>)this.createOnEventSourcingHandler());
        definition.getCommand().stream().map(commandDefinition -> {
            String creationalPolicy = commandDefinition.getCreationalPolicy();
            String commandName = commandDefinition.getOperation().getId();
            if (creationalPolicy.equals("always")) {
                return new DynamicConstructorCommandMessageHandlerMember(this.dynamicCommandProcessor, aggregateType, commandName);
            }
            if (creationalPolicy.equals("never")) {
                return new DynamicMethodCommandMessageHandlerMember(this.dynamicCommandProcessor, aggregateType, commandName);
            }
            if (creationalPolicy.equals("if_missing")) {
                return new DynamicCreateIfMissingCommandMessageHandlerMember(this.dynamicCommandProcessor, aggregateType, commandName);
            }
            throw CannotProvideDynamicAggregateConfigurationFromAggregateDefinition.becauseCommandHandlerDefinitionHasUnknownCreationalPolicy(commandDefinition);
        }).forEach(modelBuilder::addCommandHandler);
        return new DynamicAggregateConfiguration(this.dynamicCommandProcessor, this.eventStore, (SnapshotTriggerDefinition)NoSnapshotTriggerDefinition.INSTANCE, (SnapshotFilter)RevisionSnapshotFilter.builder().type(aggregateType).revision(null).build(), arg_0 -> ((Configuration)this.configuration).repository(arg_0), this.spanFactory, null, this.parameterResolverFactory, this.commandTargetResolver, modelBuilder.build());
    }

    @NotNull
    private AnnotatedMessageHandlingMember<DynamicAggregate> createOnEventSourcingHandler() {
        try {
            return new AnnotatedMessageHandlingMember((Executable)DynamicAggregate.class.getMethod("onEvent", AggregateGraphUpdatedEvent.class), EventMessage.class, GraphUpdatedEvent.class, this.parameterResolverFactory);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

