/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.axonsystem.dynamic.messagehandler;

import ai.stapi.axonsystem.dynamic.messagehandler.DynamicMessageHandler;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.axonframework.common.ObjectUtils;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.common.annotation.AnnotationUtils;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotation.MessageHandler;
import org.axonframework.spring.config.MessageHandlerConfigurer;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.core.annotation.OrderUtils;

public class DynamicMessageHandlerLookup
implements BeanDefinitionRegistryPostProcessor {
    private static final Logger logger = Logger.getLogger(DynamicMessageHandlerLookup.class.getSimpleName());

    public static List<String> messageHandlerBeans(Class<? extends Message<?>> messageType, ConfigurableListableBeanFactory registry) {
        return DynamicMessageHandlerLookup.messageHandlerBeans(messageType, registry, false);
    }

    public static List<String> messageHandlerBeans(Class<? extends Message<?>> messageType, ConfigurableListableBeanFactory registry, boolean includePrototypeBeans) {
        ArrayList<String> found = new ArrayList<String>();
        for (String beanName : registry.getBeanDefinitionNames()) {
            Class beanType;
            BeanDefinition bd = registry.getBeanDefinition(beanName);
            if (!includePrototypeBeans && (!bd.isSingleton() || bd.isAbstract()) || (beanType = registry.getType(beanName)) == null || !DynamicMessageHandlerLookup.shouldBeRegistered(messageType, beanType)) continue;
            found.add(beanName);
        }
        return found;
    }

    private static boolean shouldBeRegistered(Class<? extends Message<?>> messageType, Class<?> beanType) {
        boolean hasDynamic = false;
        for (Method m : ReflectionUtils.methodsOf(beanType)) {
            Optional normalAttr = AnnotationUtils.findAnnotationAttributes((AnnotatedElement)m, MessageHandler.class);
            if (normalAttr.isPresent()) {
                return false;
            }
            Optional dynamicAttr = AnnotationUtils.findAnnotationAttributes((AnnotatedElement)m, DynamicMessageHandler.class);
            if (!dynamicAttr.isPresent() || !messageType.isAssignableFrom((Class)((Map)dynamicAttr.get()).get("messageType"))) continue;
            hasDynamic = true;
        }
        return hasDynamic;
    }

    public void postProcessBeanFactory(@Nonnull ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (!(beanFactory instanceof BeanDefinitionRegistry)) {
            logger.warning("Given bean factory is not a BeanDefinitionRegistry. Cannot auto-configure message handlers");
            return;
        }
        for (MessageHandlerConfigurer.Type value : MessageHandlerConfigurer.Type.values()) {
            String configurerBeanName = "DynamicMessageHandlerConfigurer$$Axon$$" + value.name();
            if (beanFactory.containsBeanDefinition(configurerBeanName)) {
                logger.info("Dynamic message handler configurer already available. Skipping configuration");
                break;
            }
            List<String> found = DynamicMessageHandlerLookup.messageHandlerBeans(value.getMessageType(), beanFactory);
            if (found.isEmpty()) continue;
            List<String> sortedFound = this.sortByOrder(found, beanFactory);
            AbstractBeanDefinition beanDefinition = BeanDefinitionBuilder.genericBeanDefinition(MessageHandlerConfigurer.class).addConstructorArgValue((Object)value.name()).addConstructorArgValue(sortedFound).getBeanDefinition();
            ((BeanDefinitionRegistry)beanFactory).registerBeanDefinition(configurerBeanName, (BeanDefinition)beanDefinition);
        }
    }

    private List<String> sortByOrder(List<String> found, @Nonnull ConfigurableListableBeanFactory beanFactory) {
        return found.stream().collect(Collectors.toMap(beanRef -> beanRef, beanRef -> OrderUtils.getOrder((Class)((Class)ObjectUtils.getOrDefault((Object)beanFactory.getType(beanRef), Object.class)), (int)Integer.MAX_VALUE))).entrySet().stream().sorted(Map.Entry.comparingByValue()).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public void postProcessBeanDefinitionRegistry(@Nonnull BeanDefinitionRegistry registry) throws BeansException {
    }
}

