/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.axonsystem.dynamic.aggregate;

import ai.stapi.axonsystem.dynamic.aggregate.DynamicAggregate;
import ai.stapi.axonsystem.dynamic.aggregate.DynamicAggregateConfiguration;
import ai.stapi.axonsystem.dynamic.aggregate.DynamicAggregateConfigurationsProvider;
import ai.stapi.axonsystem.dynamic.aggregate.RuntimeDynamicAggregateConfigurer;
import java.util.ArrayList;
import java.util.List;
import org.axonframework.config.AggregateConfiguration;
import org.axonframework.config.Configurer;
import org.axonframework.config.ConfigurerModule;
import org.jetbrains.annotations.NotNull;

public class DynamicAggregateConfigurer
implements ConfigurerModule {
    private final DynamicAggregateConfigurationsProvider dynamicAggregateConfigurationsProvider;
    private final RuntimeDynamicAggregateConfigurer runtimeDynamicAggregateConfigurer;
    private final List<String> configuredAggregates;

    public DynamicAggregateConfigurer(DynamicAggregateConfigurationsProvider dynamicAggregateConfigurationsProvider, RuntimeDynamicAggregateConfigurer runtimeDynamicAggregateConfigurer) {
        this.dynamicAggregateConfigurationsProvider = dynamicAggregateConfigurationsProvider;
        this.runtimeDynamicAggregateConfigurer = runtimeDynamicAggregateConfigurer;
        this.configuredAggregates = new ArrayList<String>();
    }

    public void configureModule(@NotNull Configurer configurer) {
        List<DynamicAggregateConfiguration> aggregateConfigurations = this.dynamicAggregateConfigurationsProvider.provide();
        aggregateConfigurations.forEach(configuration -> {
            configurer.configureAggregate((AggregateConfiguration)configuration);
            Class<DynamicAggregate> aggregateClass = configuration.aggregateType();
            if (aggregateClass.equals(DynamicAggregate.class)) {
                this.configuredAggregates.add(configuration.getAggregateType());
            } else {
                this.configuredAggregates.add(aggregateClass.getCanonicalName());
            }
        });
    }

    public void configureNewAggregates() {
        List<DynamicAggregateConfiguration> currentConfigs = this.dynamicAggregateConfigurationsProvider.provide();
        currentConfigs.stream().filter(config -> !this.configuredAggregates.contains(config.getAggregateType())).forEach(this.runtimeDynamicAggregateConfigurer::add);
    }
}

