/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.axonsystem.configuration;

import ai.stapi.axonsystem.commandpersisting.CommandMessageStore;
import ai.stapi.axonsystem.commandpersisting.InMemoryCommandMessageStore;
import ai.stapi.axonsystem.commandpersisting.PersistCommandInterceptor;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Profile;

@AutoConfiguration
public class CommandPersistingConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={CommandMessageStore.class})
    public InMemoryCommandMessageStore inMemoryCommandMessageStore() {
        return new InMemoryCommandMessageStore();
    }

    @Bean
    @ConditionalOnBean(value={CommandMessageStore.class})
    @Profile(value={"dev"})
    public PersistCommandInterceptor persistCommandInterceptor(CommandMessageStore commandMessageStore) {
        return new PersistCommandInterceptor(commandMessageStore);
    }
}

