/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.test.fixtureQueryTest;

import ai.stapi.graphsystem.messaging.query.Query;
import ai.stapi.graphsystem.messaging.query.Response;
import ai.stapi.test.base.AbstractAxonTestCase;
import ai.stapi.test.schemaintegration.StructureDefinitionScope;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.thoughtworks.xstream.XStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import org.axonframework.messaging.responsetypes.ResponseTypes;
import org.axonframework.queryhandling.QueryGateway;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.xml.XStreamSerializer;
import org.junit.jupiter.api.Assertions;
import org.springframework.beans.factory.annotation.Autowired;

@StructureDefinitionScope(value={"system"})
public abstract class AbstractFixtureQueryTestCase
extends AbstractAxonTestCase {
    @Autowired
    private QueryGateway queryGateway;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private XStream xStream;

    @Deprecated
    protected void thenQueryWillReturnResponseOfType(Query query, Class<? extends Object> expectedResponseType) {
        CompletableFuture completableFuture = this.queryGateway.query((Object)query, ResponseTypes.instanceOf(expectedResponseType));
        Object actualEntity = null;
        try {
            actualEntity = completableFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            Thread.currentThread().interrupt();
        }
        Assertions.assertNotNull(actualEntity);
    }

    protected <T> T whenQueryIsDispatched(Query query, Class<T> expectedResponseType) {
        CompletableFuture completableFuture = this.queryGateway.query((Object)query, ResponseTypes.instanceOf(expectedResponseType));
        T actualResponse = null;
        try {
            actualResponse = completableFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            Thread.currentThread().interrupt();
        }
        Assertions.assertNotNull(actualResponse);
        this.thenQueryCanBeSerialized(query);
        if (actualResponse != null) {
            this.thenResponseCanBeSerializedWithJsonSerializer(actualResponse);
        }
        return actualResponse;
    }

    @Nullable
    protected <T> T whenNullableQueryIsDispatched(Query query, Class<T> expectedResponseType) {
        CompletableFuture completableFuture = this.queryGateway.query((Object)query, ResponseTypes.instanceOf(expectedResponseType));
        T actualResponse = null;
        try {
            actualResponse = completableFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            Thread.currentThread().interrupt();
        }
        Assertions.assertNotNull(actualResponse);
        this.thenQueryCanBeSerialized(query);
        if (actualResponse != null) {
            this.thenResponseCanBeSerializedWithJsonSerializer(actualResponse);
        }
        return actualResponse;
    }

    protected <T> List<T> whenQueryReturningListIsDispatched(Query query, Class<T> expectedResponseType) {
        List<Object> actualResponse = this.makeQueryReturningList(query, expectedResponseType);
        if (actualResponse == null) {
            Assertions.fail((String)"Response is null");
            throw new RuntimeException("Response is null");
        }
        this.thenQueryCanBeSerialized(query);
        actualResponse.forEach(this::thenResponseCanBeSerializedWithJsonSerializer);
        return actualResponse;
    }

    protected <T> List<T> givenQueryReturningListIsDispatched(Query query, Class<T> expectedResponseType) {
        return this.makeQueryReturningList(query, expectedResponseType);
    }

    private <T> List<T> makeQueryReturningList(Query query, Class<T> expectedResponseType) {
        CompletableFuture completableFuture = this.queryGateway.query((Object)query, ResponseTypes.multipleInstancesOf(expectedResponseType));
        List actualResponse = null;
        try {
            actualResponse = (List)completableFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            Thread.currentThread().interrupt();
        }
        Assertions.assertNotNull((Object)actualResponse);
        return actualResponse;
    }

    private void thenQueryCanBeSerialized(Object queryToSerialize) {
        this.thenQueryCanBeSerializedWithXStream(queryToSerialize);
        this.thenQueryCanBeSerializedWithJsonSerializer(queryToSerialize);
    }

    private void thenQueryCanBeSerializedWithXStream(Object queryToSerialize) {
        XStreamSerializer serializer = XStreamSerializer.builder().xStream(this.xStream).build();
        SerializedObject serializedQuery = serializer.serialize(queryToSerialize, String.class);
        Object deserializedObject = serializer.deserialize(serializedQuery);
        Assertions.assertTrue((boolean)(deserializedObject instanceof Query), (String)(deserializedObject.getClass() + " does not implement query interface."));
        Query deserializedQuery = (Query)deserializedObject;
        Assertions.assertEquals(queryToSerialize.getClass(), deserializedQuery.getClass());
    }

    private void thenQueryCanBeSerializedWithJsonSerializer(Object queryToSerialize) {
        Object deserializedObject;
        String serializedQuery;
        ObjectMapper serializer = this.objectMapper;
        serializer.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        try {
            serializedQuery = serializer.writeValueAsString(queryToSerialize);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        try {
            deserializedObject = serializer.readValue(serializedQuery, queryToSerialize.getClass());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        Assertions.assertTrue((boolean)(deserializedObject instanceof Query), (String)(deserializedObject.getClass() + " does not implement query interface."));
        Query deserializedQuery = (Query)deserializedObject;
        Assertions.assertEquals(queryToSerialize.getClass(), deserializedQuery.getClass());
    }

    private void thenResponseCanBeSerializedWithJsonSerializer(Object responseToSerialize) {
        ObjectMapper serializer = this.objectMapper;
        serializer.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        try {
            serializer.writeValueAsString(responseToSerialize);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        Assertions.assertTrue((responseToSerialize instanceof Response || responseToSerialize instanceof LinkedHashMap ? 1 : 0) != 0, (String)(responseToSerialize.getClass() + " does not implement the \"Response\" interface. \n Object returned from query must implement \"" + Response.class + "\" interface."));
    }
}

