/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.test.base;

import ai.stapi.axonsystem.dynamic.aggregate.DynamicAggregateConfigurer;
import ai.stapi.graph.Graph;
import ai.stapi.graph.graphElementForRemoval.GraphElementForRemoval;
import ai.stapi.graphsystem.messaging.event.DynamicGraphUpdatedEvent;
import ai.stapi.graphsystem.messaging.event.Event;
import ai.stapi.graphsystem.messaging.event.GraphUpdatedEvent;
import ai.stapi.identity.UniqueIdentifier;
import ai.stapi.objectRenderer.infrastructure.objectToJsonStringRenderer.ObjectToJSonStringOptions;
import ai.stapi.test.domain.TestInMemoryEventStorageEngine;
import ai.stapi.test.schemaintegration.AbstractSchemaIntegrationTestCase;
import ai.stapi.utils.LineFormatter;
import ai.stapi.utils.Retryable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.TrackedEventMessage;
import org.axonframework.eventhandling.TrackingEventStream;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.eventhandling.tokenstore.TokenStore;
import org.axonframework.eventsourcing.eventstore.EmbeddedEventStore;
import org.axonframework.eventsourcing.eventstore.EventStorageEngine;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MetaData;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.Serializer;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Order;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class AbstractAxonTestCase
extends AbstractSchemaIntegrationTestCase {
    @Autowired
    @Qualifier(value="messageSerializer")
    protected Serializer serializer;
    @Autowired
    private TokenStore tokenstore;
    @Autowired
    private EmbeddedEventStore eventStore;
    @Autowired
    private EventStorageEngine eventStorageEngine;
    @Autowired
    private DynamicAggregateConfigurer dynamicAggregateConfigurer;
    private Instant testStartedAt;

    @BeforeEach
    @Order(value=1)
    protected void configureAggregates() {
        this.dynamicAggregateConfigurer.configureNewAggregates();
    }

    @BeforeEach
    protected void initStartedAt() {
        this.testStartedAt = Instant.now();
        EventStorageEngine eventStorageEngine = this.eventStorageEngine;
        if (eventStorageEngine instanceof TestInMemoryEventStorageEngine) {
            TestInMemoryEventStorageEngine testStorage = (TestInMemoryEventStorageEngine)eventStorageEngine;
            testStorage.reset();
        }
    }

    protected void thenExpectedEventTypesSaved(Class<?> ... expectedEventTypes) {
        this.thenExpectedEventTypesSaved(Arrays.stream(expectedEventTypes).toList());
    }

    protected void thenExpectedEventTypesSaved(List<Class<?>> expectedEventTypes) {
        int retries = 20;
        int expectedEventCount = expectedEventTypes.size();
        List actualEventTypes = (List)Retryable.retry((int)retries, (long)200L, () -> {
            List<Class<?>> eventTypes = this.getActualEventTypes(this.getActualEventStream());
            return eventTypes;
        }, (Integer)expectedEventCount);
        Assertions.assertEquals((int)expectedEventTypes.size(), (int)actualEventTypes.size(), (String)this.getErrorMessage(expectedEventTypes, actualEventTypes));
        this.assertEventTypeListsAreSame(expectedEventTypes, actualEventTypes);
        this.thenSavedEventsCanBeSerialized();
    }

    protected void thenExpectedDynamicEventsSaved(String ... expectedEventNames) {
        this.thenExpectedDynamicEventsSaved(Arrays.stream(expectedEventNames).toList());
    }

    protected void thenExpectedDynamicEventsSaved(List<String> expectedEventNames) {
        List actualEventsOfType = (List)Retryable.retry((int)100, (long)100L, () -> {
            TrackingEventStream actualEventStream = this.getActualEventStream();
            List eventsOfType = this.getActualEvents(actualEventStream).stream().filter(o -> o instanceof DynamicGraphUpdatedEvent).map(o -> (DynamicGraphUpdatedEvent)o).collect(Collectors.toList());
            return eventsOfType;
        }, (Integer)expectedEventNames.size());
        Assertions.assertEquals((int)expectedEventNames.size(), (int)actualEventsOfType.size(), (String)this.getDynamicEventsErrorMessage(expectedEventNames, actualEventsOfType));
        this.assertDynamicEventsHaveCorrectNames(expectedEventNames, actualEventsOfType);
        this.thenSavedEventsCanBeSerialized();
    }

    protected <T extends Event> T getLastEventOfType(Class<T> eventType) {
        return this.getLastEventOfType(eventType, 1);
    }

    protected DynamicGraphUpdatedEvent getLastDynamicEventOfName(String eventName) {
        return this.getLastDynamicEventOfName(eventName, 1);
    }

    protected DynamicGraphUpdatedEvent getLastDynamicEventOfName(String eventName, int expectedNumberOfEvents) {
        List actualEventsOfType = (List)Retryable.retry((int)100, (long)100L, () -> {
            TrackingEventStream actualEventStream = this.getActualEventStream();
            List eventsOfType = this.getActualEvents(actualEventStream).stream().filter(o -> o instanceof DynamicGraphUpdatedEvent).map(o -> (DynamicGraphUpdatedEvent)o).filter(dynamicGraphUpdatedEvent -> dynamicGraphUpdatedEvent.getEventName().equals(eventName)).collect(Collectors.toList());
            return eventsOfType;
        }, (Integer)expectedNumberOfEvents);
        Assertions.assertNotNull((Object)actualEventsOfType, (String)"No events found.");
        Assertions.assertEquals((int)expectedNumberOfEvents, (int)actualEventsOfType.size(), (String)"Not enough events found.");
        return (DynamicGraphUpdatedEvent)actualEventsOfType.get(actualEventsOfType.size() - 1);
    }

    protected <T extends Event> T getLastEventOfType(Class<T> eventType, int expectedNumberOfEvents) {
        List actualEventsOfType = (List)Retryable.retry((int)100, (long)100L, () -> {
            TrackingEventStream actualEventStream = this.getActualEventStream();
            List eventsOfType = this.getActualEvents(actualEventStream).stream().filter(o -> o.getClass().equals(eventType)).collect(Collectors.toList());
            return eventsOfType;
        }, (Integer)expectedNumberOfEvents);
        Assertions.assertNotNull((Object)actualEventsOfType, (String)"No events found.");
        Assertions.assertEquals((int)expectedNumberOfEvents, (int)actualEventsOfType.size(), (String)"Not enough events found.");
        return (T)((Event)actualEventsOfType.get(actualEventsOfType.size() - 1));
    }

    protected MetaData getMetaDataForLastEventOfType(Class<? extends Event> eventType) {
        List<MetaData> metaData = this.getActualEventStream().asStream().filter(eventMessage -> eventMessage.getPayloadType().equals(eventType)).map(Message::getMetaData).toList();
        Assertions.assertTrue((metaData.size() > 0 ? 1 : 0) != 0, (String)"No such events found.");
        return metaData.get(metaData.size() - 1);
    }

    protected <T extends Event> Optional<T> getLastEventOfTypeOptionally(Class<T> eventType) {
        TrackingEventStream actualEventStream = this.getActualEventStream();
        return this.getActualEvents(actualEventStream).stream().filter(o -> o.getClass().equals(eventType)).map(event -> (Event)event).findAny();
    }

    protected void thenLastEventElementsForRemovalApproved() {
        TrackingEventStream actualEventStream = this.getActualEventStream();
        List<Object> actualEvents = this.getActualEvents(actualEventStream);
        Object uncheckedActualEvent = actualEvents.get(actualEvents.size() - 1);
        Assertions.assertTrue((boolean)(uncheckedActualEvent instanceof GraphUpdatedEvent));
        GraphUpdatedEvent actualEvent = (GraphUpdatedEvent)uncheckedActualEvent;
        this.approveElementsForRemoval(actualEvent.getGraphElementsForRemoval());
    }

    protected void thenLastEventElementsForRemovalApproved(Class<? extends Event> eventType) {
        Event uncheckedActualEvent = this.getLastEventOfType(eventType);
        Assertions.assertTrue((boolean)(uncheckedActualEvent instanceof GraphUpdatedEvent));
        GraphUpdatedEvent actualEvent = (GraphUpdatedEvent)uncheckedActualEvent;
        this.approveElementsForRemoval(actualEvent.getGraphElementsForRemoval());
    }

    protected void thenLastEventGraphApproved() {
        TrackingEventStream actualEventStream = this.getActualEventStream();
        List<Object> actualEvents = this.getActualEvents(actualEventStream);
        Object uncheckedActualEvent = actualEvents.get(actualEvents.size() - 1);
        Assertions.assertTrue((boolean)(uncheckedActualEvent instanceof GraphUpdatedEvent));
        GraphUpdatedEvent actualEvent = (GraphUpdatedEvent)uncheckedActualEvent;
        this.thenGraphApproved(actualEvent.getSynchronizedGraph());
    }

    protected void thenLastEventOfTypeGraphApproved(Class<? extends Event> eventType) {
        this.thenLastEventOfTypeGraphApproved(eventType, 1);
    }

    protected void thenLastEventOfTypeGraphApproved(Class<? extends Event> eventType, int expectedNumberOfEvents) {
        Event uncheckedActualEvent = this.getLastEventOfType(eventType, expectedNumberOfEvents);
        Assertions.assertTrue((boolean)(uncheckedActualEvent instanceof GraphUpdatedEvent));
        GraphUpdatedEvent actualEvent = (GraphUpdatedEvent)uncheckedActualEvent;
        this.thenGraphApproved(actualEvent.getSynchronizedGraph());
    }

    protected void thenLastDynamicEventOfNameApproved(String eventName) {
        DynamicGraphUpdatedEvent actualEvent = this.getLastDynamicEventOfName(eventName);
        this.thenGraphApproved(actualEvent.getSynchronizedGraph());
    }

    protected void thenLastDynamicEventOfNameApproved(String eventName, int expectedNumberOfEvents) {
        DynamicGraphUpdatedEvent actualEvent = this.getLastDynamicEventOfName(eventName, expectedNumberOfEvents);
        this.thenGraphApproved(actualEvent.getSynchronizedGraph());
    }

    protected void thenMergedGraphOfAggregateApproved(UniqueIdentifier aggregateIdentifier) {
        this.thenMergedGraphOfAggregateApproved(aggregateIdentifier.getId());
    }

    protected List<TrackedEventMessage<?>> getAllTrackedMessagesWithPayloadType(Class<? extends Event> eventType) {
        List<TrackedEventMessage<?>> eventMessages = this.getActualEventMessages(this.getActualEventStream());
        return eventMessages.stream().filter(message -> message.getPayloadType().equals(eventType)).toList();
    }

    protected <T extends Event> TrackedEventMessage<T> getLastEventMessagesOfPayloadType(Class<T> eventType) {
        boolean expectedNumberOfMessages = true;
        List actualEvents = (List)Retryable.retry((int)20, (long)100L, () -> {
            List<TrackedEventMessage> currentActualEvents = this.getActualEventMessages(this.getActualEventStream()).stream().filter(message -> message.getPayloadType().equals(eventType)).toList();
            return currentActualEvents;
        }, (Integer)1);
        Assertions.assertTrue((actualEvents.size() > 0 ? 1 : 0) != 0, (String)"No events of that type found.");
        return (TrackedEventMessage)actualEvents.get(actualEvents.size() - 1);
    }

    protected void thenMergedGraphOfAggregateApproved(String aggregateIdentifier) {
        List<TrackedEventMessage<?>> allEventMessages = this.getActualEventMessages(this.getActualEventStream());
        Graph mergedGraph = allEventMessages.stream().filter(message -> message instanceof DomainEventMessage).map(message -> (DomainEventMessage)message).filter(message -> message.getAggregateIdentifier().equals(aggregateIdentifier)).map(Message::getPayload).filter(payload -> payload instanceof GraphUpdatedEvent).map(payload -> (GraphUpdatedEvent)payload).reduce(new Graph(), this::reduceGraphEvent, Graph::merge);
        this.thenGraphApproved(mergedGraph);
    }

    private Graph reduceGraphEvent(Graph reduced, GraphUpdatedEvent event) {
        return reduced.removeGraphElements(event.getGraphElementsForRemoval()).merge(event.getSynchronizedGraph());
    }

    private void approveElementsForRemoval(List<GraphElementForRemoval> removals) {
        this.thenObjectApproved(removals.stream().sorted(Comparator.comparing(GraphElementForRemoval::getGraphElementId)).collect(Collectors.toList()), new ObjectToJSonStringOptions(new ObjectToJSonStringOptions.RenderFeature[]{ObjectToJSonStringOptions.RenderFeature.SORT_FIELDS, ObjectToJSonStringOptions.RenderFeature.HIDE_IDS}));
    }

    private void thenSavedEventsCanBeSerialized() {
        List<Object> actualEvents = this.getActualEvents(this.getActualEventStream());
        actualEvents.forEach(this::thenEventCanBeSerialized);
    }

    private void thenEventCanBeSerialized(Object recordedEvent) {
        SerializedObject serializedEvent = this.serializer.serialize(recordedEvent, String.class);
        Object deserializedObject = this.serializer.deserialize(serializedEvent);
        Assertions.assertTrue((boolean)(deserializedObject instanceof Event), (String)String.format("\n%s\ndoes not implement:\n%s.", deserializedObject.getClass(), Event.class));
        Event deserializedEvent = (Event)deserializedObject;
        Assertions.assertEquals(recordedEvent.getClass(), deserializedEvent.getClass());
    }

    private void assertEventTypeListsAreSame(List<Class<?>> expectedEventTypes, List<Class<?>> actualEventTypes) {
        Iterator<Class<?>> actualEventTypesIterator = actualEventTypes.iterator();
        expectedEventTypes.forEach(expectedEventType -> Assertions.assertEquals((Object)expectedEventType, actualEventTypesIterator.next(), (String)this.getErrorMessage(expectedEventTypes, actualEventTypes)));
    }

    private void assertDynamicEventsHaveCorrectNames(List<String> expectedEventNames, List<DynamicGraphUpdatedEvent> actualEvents) {
        Iterator<DynamicGraphUpdatedEvent> actualEventsIterator = actualEvents.iterator();
        expectedEventNames.forEach(expectedEventName -> Assertions.assertEquals((Object)expectedEventName, (Object)((DynamicGraphUpdatedEvent)actualEventsIterator.next()).getEventName(), (String)this.getDynamicEventsErrorMessage(expectedEventNames, actualEvents)));
    }

    @NotNull
    private String getDynamicEventsErrorMessage(List<String> expectedEventNames, List<DynamicGraphUpdatedEvent> actualEvents) {
        return "Expected event names dont match.\nExpected: %s\nActual: %s".formatted(expectedEventNames, actualEvents.stream().map(DynamicGraphUpdatedEvent::getEventName).toList());
    }

    private List<Class<?>> getActualEventTypes(TrackingEventStream actualEventStream) {
        ArrayList actualEventTypes = new ArrayList();
        while (actualEventStream.hasNextAvailable()) {
            actualEventTypes.add(this.getActualEventType(actualEventStream));
        }
        actualEventStream.close();
        return actualEventTypes;
    }

    public List<Object> getActualEvents(TrackingEventStream actualEventStream) {
        ArrayList<Object> actualEvents = new ArrayList<Object>();
        while (actualEventStream.hasNextAvailable()) {
            actualEvents.add(this.getActualEvent(actualEventStream));
        }
        actualEventStream.close();
        return actualEvents;
    }

    private Object getActualEvent(TrackingEventStream actualEventStream) {
        try {
            return ((TrackedEventMessage)actualEventStream.nextAvailable()).getPayload();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    private List<TrackedEventMessage<?>> getActualEventMessages(TrackingEventStream actualEventStream) {
        ArrayList actualEvents = new ArrayList();
        while (actualEventStream.hasNextAvailable()) {
            actualEvents.add(this.getActualEventMessage(actualEventStream));
        }
        actualEventStream.close();
        return actualEvents;
    }

    private TrackedEventMessage<?> getActualEventMessage(TrackingEventStream actualEventStream) {
        try {
            return (TrackedEventMessage)actualEventStream.nextAvailable();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    private Class<?> getActualEventType(TrackingEventStream actualEventStream) {
        try {
            return ((TrackedEventMessage)actualEventStream.nextAvailable()).getPayloadType();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    protected String getErrorMessage(List<Class<?>> expectedEventTypes, List<Class<?>> actualEventTypes) {
        String title = LineFormatter.createLine((String)"Actual event types differ from expected event types.");
        String expectedTitle = LineFormatter.createLine((String)"Expected:");
        String expectedString = LineFormatter.createLines(expectedEventTypes.stream().map(Class::toString));
        String actualTitle = LineFormatter.createLine((String)"Actual:");
        String actualString = LineFormatter.createLines(actualEventTypes.stream().map(Class::toString));
        return title + expectedTitle + expectedString + actualTitle + actualString;
    }

    private String getErrorMessage(Class<?> expectedEventType, List<Class<?>> actualEventTypes) {
        String title = LineFormatter.createLine((String)"Actual event types does not contain expected event type.");
        String expectedTitle = LineFormatter.createLine((String)"Expected:");
        String expectedString = LineFormatter.createLine((String)expectedEventType.toString());
        String actualTitle = LineFormatter.createLine((String)"Actual:");
        String actualString = LineFormatter.createLines(actualEventTypes.stream().map(Class::toString));
        return title + expectedTitle + expectedString + actualTitle + actualString;
    }

    private TrackingEventStream getActualEventStream() {
        TrackingToken token = this.eventStore.createTokenAt(this.testStartedAt);
        return this.eventStore.openStream(token);
    }
}

