/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.test.domain;

import ai.stapi.graphsystem.messaging.command.Command;
import ai.stapi.graphsystem.messaging.command.EndpointCommand;
import ai.stapi.test.base.AbstractAxonTestCase;
import ai.stapi.test.schemaintegration.StructureDefinitionScope;
import java.util.Map;
import java.util.Optional;
import org.axonframework.commandhandling.CommandExecutionException;
import org.axonframework.commandhandling.GenericCommandMessage;
import org.axonframework.commandhandling.gateway.CommandGateway;
import org.axonframework.messaging.MetaData;
import org.axonframework.serialization.SerializedObject;
import org.junit.jupiter.api.Assertions;
import org.springframework.beans.factory.annotation.Autowired;

@StructureDefinitionScope(value={"system"})
public abstract class AbstractDomainTestCase
extends AbstractAxonTestCase {
    @Autowired
    private CommandGateway commandGateway;

    private static boolean validCommandClass(Object deserializedObject) {
        return deserializedObject instanceof Command || deserializedObject instanceof Map;
    }

    protected void givenCommandIsDispatched(Object command) {
        this.commandGateway.sendAndWait(command);
    }

    protected void whenCommandIsDispatched(Object command) {
        this.commandGateway.sendAndWait(command);
        if (command instanceof GenericCommandMessage) {
            GenericCommandMessage genericCommandMessage = (GenericCommandMessage)command;
            command = genericCommandMessage.getPayload();
        }
        this.thenCommandCanBeSerialized(command);
    }

    protected void whenCommandIsDispatched(Object command, MetaData metaData) {
        this.commandGateway.sendAndWait(command, metaData);
        this.thenCommandCanBeSerialized(command);
    }

    protected Optional<CommandExecutionException> whenCommandThrowingExceptionIsDispatched(Object command) {
        try {
            this.commandGateway.sendAndWait(command);
        }
        catch (CommandExecutionException e) {
            return Optional.of(e);
        }
        return Optional.empty();
    }

    private void thenCommandCanBeSerialized(Object commandToSerialize) {
        this.thenCommandCanBeSerializedWithXSStream(commandToSerialize);
        if (commandToSerialize instanceof EndpointCommand) {
            this.thenCommandCanBeSerializedWithJsonSerializer(commandToSerialize);
        }
    }

    private void thenCommandCanBeSerializedWithXSStream(Object commandToSerialize) {
        SerializedObject serializedCommand = this.serializer.serialize(commandToSerialize, String.class);
        Object deserializedObject = this.serializer.deserialize(serializedCommand);
        Assertions.assertTrue((boolean)AbstractDomainTestCase.validCommandClass(deserializedObject), (String)(deserializedObject.getClass() + " does not implement command interface."));
        Assertions.assertEquals(commandToSerialize.getClass(), deserializedObject.getClass());
    }

    private void thenCommandCanBeSerializedWithJsonSerializer(Object commandToSerialize) {
        SerializedObject serializedCommand = this.serializer.serialize(commandToSerialize, String.class);
        Object deserializedObject = this.serializer.deserialize(serializedCommand);
        Assertions.assertTrue((boolean)AbstractDomainTestCase.validCommandClass(deserializedObject), (String)(deserializedObject.getClass() + " does not implement Command interface."));
        Command deserializedCommand = (Command)deserializedObject;
        Assertions.assertEquals(commandToSerialize.getClass(), deserializedCommand.getClass());
    }
}

