/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.test;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public interface FixtureFileLoadableTestTrait {
    default public String getFixtureFilePath(String fixtureFile) {
        String relativeTestFolderPath = this.getRelativeTestFolderPath();
        return this.getAbsoluteFixturePath(fixtureFile, relativeTestFolderPath);
    }

    default public List<String> getAllFixtureFiles() {
        File fixtureFolder = this.getFixtureFolder();
        return new ArrayList<String>(Arrays.stream(Objects.requireNonNull(fixtureFolder.listFiles())).filter(File::isFile).map(File::getAbsolutePath).toList());
    }

    default public String getLocationFilePath() {
        return System.getProperty("user.dir") + "/src/test/java/" + this.getRelativeTestFolderPath();
    }

    default public File getFixtureFolder() {
        return new File(System.getProperty("user.dir") + "/src/test/java/" + this.getRelativeTestFolderPath() + "/fixtures");
    }

    default public String getAbsoluteFixturePath(String fixtureFile, String relativeTestFolderPath) {
        return System.getProperty("user.dir") + "/src/test/java/" + relativeTestFolderPath + "/fixtures/" + fixtureFile;
    }

    default public String getRelativeTestFolderPath() {
        String canonicalName = this.getClass().getCanonicalName();
        String[] split = canonicalName.split("\\.");
        return String.join((CharSequence)"/", Arrays.copyOfRange(canonicalName.split("\\."), 0, split.length - 1));
    }
}

