/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.test.schemaintegration;

import ai.stapi.schema.scopeProvider.ScopeOptions;
import ai.stapi.schema.scopeProvider.ScopeProvider;
import ai.stapi.test.integration.AbstractIntegrationTestCase;
import ai.stapi.test.schemaintegration.StructureDefinitionScope;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.TestInfo;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractSchemaIntegrationTestCase
extends AbstractIntegrationTestCase {
    @Autowired
    private ScopeProvider scopeProvider;

    @BeforeAll
    @Order(value=0)
    public static void setTestClassScopeBeforeAll(TestInfo testInfo, @Autowired ScopeProvider scopeProvider) {
        Optional testClass = testInfo.getTestClass();
        testClass.ifPresent(clazz -> {
            List<String> testScopes = AbstractSchemaIntegrationTestCase.gatherScopeAnnotations(clazz);
            scopeProvider.set(new ScopeOptions(testScopes, List.of("domain", "test")));
        });
    }

    @BeforeEach
    @Order(value=0)
    public void setTestClassScope(TestInfo testInfo) {
        Optional testClass = testInfo.getTestClass();
        testClass.ifPresent(clazz -> {
            List<String> testScopes = AbstractSchemaIntegrationTestCase.gatherScopeAnnotations(clazz);
            this.scopeProvider.set(new ScopeOptions(testScopes, List.of("domain", "test")));
        });
    }

    private static List<String> gatherScopeAnnotations(Class<?> testClazz) {
        if (testClazz == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> testScopes = new ArrayList<String>();
        Class<?> parent = testClazz.getSuperclass();
        testScopes.addAll(AbstractSchemaIntegrationTestCase.gatherScopeAnnotations(parent));
        testScopes.addAll(Arrays.stream((StructureDefinitionScope[])testClazz.getAnnotationsByType(StructureDefinitionScope.class)).map(StructureDefinitionScope::value).flatMap(Arrays::stream).collect(Collectors.toCollection(ArrayList::new)));
        return testScopes;
    }
}

