/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.serialization.jackson;

import ai.stapi.serialization.SerializableObject;
import ai.stapi.serialization.classNameProvider.GenericClassNameProvider;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;

public class SerializableObjectDeserializer<T extends SerializableObject>
extends StdDeserializer<T> {
    private GenericClassNameProvider classNameProvider;
    private ObjectMapper objectMapper;
    private Class<?> setupBeanClass;

    public SerializableObjectDeserializer(GenericClassNameProvider classNameProvider, ObjectMapper objectMapper, Class<?> setupBeanClass) {
        super(setupBeanClass);
        this.setupBeanClass = setupBeanClass;
        this.classNameProvider = classNameProvider;
        this.objectMapper = objectMapper;
    }

    public T deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        JsonNode jsonNode = node.get("serializationType");
        if (jsonNode == null) {
            throw new RuntimeException("Cannot deserialize SerializableObject, because it is missing serializationType.\nClass to be deserialized: " + this.setupBeanClass.getSimpleName() + "\nProvided data: " + node);
        }
        String serializationType = jsonNode.asText();
        Class<?> classType = this.classNameProvider.getClassType(serializationType);
        String serializedObject = node.toString();
        return (T)((SerializableObject)this.objectMapper.readValue(serializedObject, classType));
    }
}

