/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.formapi.formmapper;

import ai.stapi.formapi.formmapper.exceptions.CannotMapJsonSchema;
import ai.stapi.formapi.formmapper.exceptions.CannotPrintJSONSchema;
import ai.stapi.graphsystem.operationdefinition.model.OperationDefinitionDTO;
import ai.stapi.graphsystem.operationdefinition.model.OperationDefinitionStructureTypeMapper;
import ai.stapi.schema.structureSchema.ComplexStructureType;
import ai.stapi.schema.structureSchema.FieldDefinition;
import ai.stapi.schema.structureSchema.FieldType;
import ai.stapi.schema.structureSchemaProvider.StructureSchemaFinder;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.everit.json.schema.ArraySchema;
import org.everit.json.schema.BooleanSchema;
import org.everit.json.schema.CombinedSchema;
import org.everit.json.schema.NumberSchema;
import org.everit.json.schema.ObjectSchema;
import org.everit.json.schema.ReferenceSchema;
import org.everit.json.schema.Schema;
import org.everit.json.schema.StringSchema;

public class JsonSchemaMapper {
    public static Set<String> STRING_LIKE_PRIMITIVES = Set.of("base64Binary", "canonical", "code", "date", "dateTime", "time", "id", "instant", "markdown", "oid", "uri", "url", "uuid", "xhtml", "string");
    public static Set<String> NUMBER_LIKE_PRIMITIVES = Set.of("decimal", "positiveInt", "unsignedInt", "integer");
    private final OperationDefinitionStructureTypeMapper operationDefinitionStructureTypeMapper;
    private final StructureSchemaFinder structureSchemaFinder;

    public JsonSchemaMapper(OperationDefinitionStructureTypeMapper operationDefinitionStructureTypeMapper, StructureSchemaFinder structureSchemaFinder) {
        this.operationDefinitionStructureTypeMapper = operationDefinitionStructureTypeMapper;
        this.structureSchemaFinder = structureSchemaFinder;
    }

    public Map<String, Object> map(OperationDefinitionDTO operationDefinitionDTO) {
        return this.map(operationDefinitionDTO, true);
    }

    public Map<String, Object> map(OperationDefinitionDTO operationDefinitionDTO, Boolean omitExtension) {
        ComplexStructureType fakedStructureType = this.operationDefinitionStructureTypeMapper.map(operationDefinitionDTO);
        FormMapperContext formMapperContext = new FormMapperContext();
        ObjectSchema schema = this.getObjectSchema(fakedStructureType, formMapperContext, omitExtension);
        return this.printSchema(schema, formMapperContext);
    }

    private ObjectSchema getObjectSchema(ComplexStructureType structureType, FormMapperContext formMapperContext, Boolean omitExtension) {
        return this.getObjectSchemaWithTitle(structureType, formMapperContext, omitExtension, structureType.getDefinitionType());
    }

    private ObjectSchema getObjectSchemaWithTitle(ComplexStructureType structureType, FormMapperContext formMapperContext, Boolean omitExtension, String title) {
        ObjectSchema.Builder builder = new ObjectSchema.Builder();
        builder.title(title);
        builder.description(structureType.getDescription());
        structureType.getAllFields().values().stream().filter(field -> omitExtension == false || !field.getName().equals("extension") && !field.getName().equals("modifierExtension")).sorted(Comparator.comparing(FieldDefinition::getName)).forEach(field -> this.mapField((FieldDefinition)field, builder, formMapperContext, omitExtension));
        return builder.build();
    }

    private void mapField(FieldDefinition field, ObjectSchema.Builder builder, FormMapperContext formMapperContext, Boolean omitExtension) {
        String parameterName = field.getName();
        if (field.getMin() > 0) {
            builder.addRequiredProperty(parameterName);
        }
        if (field.getTypes().isEmpty()) {
            return;
        }
        if (field.getFloatMax().floatValue() > 1.0f) {
            this.mapArrayField(field, builder, formMapperContext, omitExtension);
            return;
        }
        Schema schema = this.getSchema(field, formMapperContext, omitExtension);
        builder.addPropertySchema(parameterName, schema);
    }

    private Schema getSchema(FieldDefinition field, FormMapperContext formMapperContext, Boolean omitExtension) {
        if (field.getTypes().size() > 1) {
            CombinedSchema.Builder schemaBuilder = new CombinedSchema.Builder().criterion(CombinedSchema.ONE_CRITERION);
            field.getTypes().stream().map((? super T type) -> this.getMemberSchema((FieldType)type, field, formMapperContext, omitExtension)).forEach(arg_0 -> ((CombinedSchema.Builder)schemaBuilder).subschema(arg_0));
            return schemaBuilder.build();
        }
        FieldType type2 = (FieldType)field.getTypes().get(0);
        return this.getMemberSchema(type2, field, formMapperContext, omitExtension);
    }

    private Schema getMemberSchema(FieldType type, FieldDefinition fieldDefinition, FormMapperContext formMapperContext, Boolean omitExtension) {
        String typeName = type.getType();
        if (type.isPrimitiveType()) {
            return this.getPrimitiveSchema(typeName, fieldDefinition);
        }
        String title = JsonSchemaMapper.formatMachineReadableToHumanReadable(fieldDefinition.getName());
        if (type.isReference()) {
            return new StringSchema.Builder().title(title).description(fieldDefinition.getDescription()).build();
        }
        if (!formMapperContext.hasType(typeName)) {
            formMapperContext.addType(typeName);
            ComplexStructureType structureType = (ComplexStructureType)this.structureSchemaFinder.getStructureType(typeName);
            ObjectSchema objectSchema = this.getObjectSchemaWithTitle(structureType, formMapperContext, omitExtension, title);
            formMapperContext.putSchema(typeName, objectSchema);
        }
        return new ReferenceSchema.Builder().refValue(String.format("#/definitions/%s", typeName)).title(title).description(fieldDefinition.getDescription()).build();
    }

    private Schema getPrimitiveSchema(String type, FieldDefinition fieldDefinition) {
        String title = JsonSchemaMapper.formatMachineReadableToHumanReadable(fieldDefinition.getName());
        if (STRING_LIKE_PRIMITIVES.contains(type)) {
            return new StringSchema.Builder().title(title).description(fieldDefinition.getDescription()).build();
        }
        if (NUMBER_LIKE_PRIMITIVES.contains(type)) {
            return new NumberSchema.Builder().title(title).description(fieldDefinition.getDescription()).build();
        }
        if (type.equals("boolean")) {
            return new BooleanSchema.Builder().title(title).description(fieldDefinition.getDescription()).build();
        }
        throw CannotMapJsonSchema.becauseUnknownPrimitiveTypeEncountered(type);
    }

    private void mapArrayField(FieldDefinition field, ObjectSchema.Builder builder, FormMapperContext formMapperContext, Boolean omitExtension) {
        Schema itemSchema = this.getSchema(field, formMapperContext, omitExtension);
        builder.addPropertySchema(field.getName(), (Schema)new ArraySchema.Builder().allItemSchema(itemSchema).build());
    }

    private Map<String, Object> printSchema(ObjectSchema schema, FormMapperContext formMapperContext) {
        try {
            HashMap map = (HashMap)new ObjectMapper().readValue(schema.toString(), (TypeReference)new TypeReference<HashMap<String, Object>>(){});
            HashMap definitionsMap = new HashMap();
            formMapperContext.getComplexTypeSchemas().forEach((typeName, definition) -> definitionsMap.put(typeName, this.printDefinition((ObjectSchema)definition)));
            map.put("definitions", definitionsMap);
            return map;
        }
        catch (JsonProcessingException e) {
            throw new CannotPrintJSONSchema(e);
        }
    }

    private Map<String, Object> printDefinition(ObjectSchema schema) {
        try {
            return (Map)new ObjectMapper().readValue(schema.toString(), (TypeReference)new TypeReference<HashMap<String, Object>>(){});
        }
        catch (JsonProcessingException e) {
            throw new CannotPrintJSONSchema(e);
        }
    }

    private static String formatMachineReadableToHumanReadable(String string) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            if (JsonSchemaMapper.shouldInsertSpace(string, i)) {
                result.append(" ");
            }
            result.append(i == 0 ? Character.toUpperCase(string.charAt(i)) : string.charAt(i));
        }
        return result.toString();
    }

    private static boolean shouldInsertSpace(String string, int index) {
        return JsonSchemaMapper.isUppercase(string, index) && (JsonSchemaMapper.isStartOfWord(string, index) || JsonSchemaMapper.isEndOfAcronym(string, index));
    }

    private static boolean isUppercase(String string, int index) {
        return Character.isUpperCase(string.charAt(index));
    }

    private static boolean isStartOfWord(String string, int index) {
        return index > 0 && !JsonSchemaMapper.isUppercase(string, index - 1);
    }

    private static boolean isEndOfAcronym(String string, int index) {
        return index < string.length() - 1 && !JsonSchemaMapper.isUppercase(string, index + 1);
    }

    private static class FormMapperContext {
        private final Set<String> encounteredComplexTypes = new HashSet<String>();
        private final Map<String, ObjectSchema> complexTypeSchemas = new HashMap<String, ObjectSchema>();

        public void putSchema(String typeName, ObjectSchema schema) {
            this.complexTypeSchemas.put(typeName, schema);
        }

        public void addType(String typeName) {
            this.encounteredComplexTypes.add(typeName);
        }

        public boolean hasType(String typeName) {
            return this.encounteredComplexTypes.contains(typeName);
        }

        public Set<String> getEncounteredComplexTypes() {
            return this.encounteredComplexTypes;
        }

        public Map<String, ObjectSchema> getComplexTypeSchemas() {
            return this.complexTypeSchemas;
        }
    }
}

