/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.formapi.formmapper;

import ai.stapi.axonsystem.dynamic.aggregate.DynamicAggregate;
import ai.stapi.axonsystem.graphaggregate.AggregateWithGraph;
import ai.stapi.formapi.formmapper.FormDataLoader;
import ai.stapi.formapi.formmapper.exceptions.CannotLoadFormData;
import ai.stapi.graph.inMemoryGraph.InMemoryGraphRepository;
import ai.stapi.graph.traversableGraphElements.TraversableNode;
import ai.stapi.graphoperations.dagtoobjectconverter.DAGToObjectConverter;
import ai.stapi.graphsystem.aggregatedefinition.model.AggregateDefinitionDTO;
import ai.stapi.graphsystem.aggregatedefinition.model.AggregateDefinitionProvider;
import ai.stapi.graphsystem.aggregatedefinition.model.CommandHandlerDefinitionDTO;
import ai.stapi.graphsystem.aggregatedefinition.model.exceptions.CannotProvideAggregateDefinition;
import ai.stapi.graphsystem.aggregategraphstatemodifier.EventFactoryModificationTraverser;
import ai.stapi.graphsystem.operationdefinition.model.OperationDefinitionDTO;
import ai.stapi.graphsystem.operationdefinition.model.OperationDefinitionStructureTypeMapper;
import ai.stapi.identity.UniqueIdentifier;
import ai.stapi.schema.structureSchema.ComplexStructureType;
import java.util.HashMap;
import java.util.Map;
import org.axonframework.commandhandling.GenericCommandMessage;
import org.axonframework.config.Configuration;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;
import org.axonframework.messaging.unitofwork.DefaultUnitOfWork;
import org.axonframework.messaging.unitofwork.UnitOfWork;
import org.axonframework.modelling.command.Aggregate;
import org.axonframework.modelling.command.AggregateNotFoundException;
import org.axonframework.modelling.command.Repository;

public class AggregateRepositoryFormDataLoader
implements FormDataLoader {
    private final Repository<DynamicAggregate> repository;
    private final AggregateDefinitionProvider aggregateDefinitionProvider;
    private final EventFactoryModificationTraverser eventFactoryModificationTraverser;
    private final OperationDefinitionStructureTypeMapper operationDefinitionStructureTypeMapper;
    private final DAGToObjectConverter dagToObjectConverter;

    public AggregateRepositoryFormDataLoader(Configuration configuration, AggregateDefinitionProvider aggregateDefinitionProvider, EventFactoryModificationTraverser eventFactoryModificationTraverser, OperationDefinitionStructureTypeMapper operationDefinitionStructureTypeMapper, DAGToObjectConverter dagToObjectConverter) {
        this.repository = configuration.repository(DynamicAggregate.class);
        this.aggregateDefinitionProvider = aggregateDefinitionProvider;
        this.eventFactoryModificationTraverser = eventFactoryModificationTraverser;
        this.operationDefinitionStructureTypeMapper = operationDefinitionStructureTypeMapper;
        this.dagToObjectConverter = dagToObjectConverter;
    }

    @Override
    public Map<String, Object> load(OperationDefinitionDTO operationDefinitionDTO, String resourceId, Map<String, Object> possibleStartIds) {
        Aggregate aggregate;
        AggregateDefinitionDTO aggregateDefinition;
        String operationId = operationDefinitionDTO.getId();
        try {
            aggregateDefinition = this.aggregateDefinitionProvider.getAggregateForOperation(operationId);
        }
        catch (CannotProvideAggregateDefinition e) {
            throw CannotLoadFormData.becauseThereWasNoCommandHandlerDefinitionForProvidedOperation(operationId, e);
        }
        CommandHandlerDefinitionDTO commandHandlerDefinition = aggregateDefinition.getCommand().stream().filter(command -> command.getOperation().getId().equals(operationId)).findFirst().orElseThrow(() -> CannotLoadFormData.becauseThereWasNoCommandHandlerDefinitionForProvidedOperation(operationId));
        DefaultUnitOfWork unitOfWork = DefaultUnitOfWork.startAndGet((Message)new GenericCommandMessage((Object)String.format("Loading state of aggregate '%s' with id '%s'. To be used as form data for operation '%s'.", aggregateDefinition.getName(), resourceId, operationId)));
        CurrentUnitOfWork.set((UnitOfWork)unitOfWork);
        try {
            aggregate = this.repository.load(resourceId);
        }
        catch (AggregateNotFoundException e) {
            throw CannotLoadFormData.becauseAggregateByProvidedResourceIdWasNotFound(resourceId, e);
        }
        finally {
            CurrentUnitOfWork.clear((UnitOfWork)unitOfWork);
        }
        ComplexStructureType operationStructureType = this.operationDefinitionStructureTypeMapper.map(operationDefinitionDTO);
        InMemoryGraphRepository state = (InMemoryGraphRepository)aggregate.invoke(AggregateWithGraph::getInMemoryGraphRepository);
        HashMap<String, Object> data = new HashMap<String, Object>();
        commandHandlerDefinition.getEventFactory().stream().flatMap(eventFactory -> eventFactory.getModification().stream()).forEach(modification -> {
            String inputValueParameterName = modification.getInputValueParameterName();
            TraversableNode traversingStart = this.eventFactoryModificationTraverser.getTraversingStartNode(aggregateDefinition.getStructure().getId(), new UniqueIdentifier(resourceId), possibleStartIds, modification, operationStructureType, state);
            String modificationPath = modification.getModificationPath();
            String[] splitPath = modificationPath.split("\\.");
            TraversableNode modifiedNode = this.eventFactoryModificationTraverser.traverseToModifiedNode(traversingStart, splitPath, operationStructureType, modification);
            String fieldName = splitPath[splitPath.length - 1];
            Map object = this.dagToObjectConverter.convert(modifiedNode);
            Object value = object.get(fieldName);
            if (value != null) {
                data.put(inputValueParameterName, value);
            }
        });
        return data;
    }
}

