/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.formapi.formmapper;

import ai.stapi.formapi.FormRequest;
import ai.stapi.formapi.formmapper.FormDataLoader;
import ai.stapi.formapi.formmapper.FormMapperResult;
import ai.stapi.formapi.formmapper.JsonSchemaMapper;
import ai.stapi.formapi.formmapper.UISchemaLoader;
import ai.stapi.graphsystem.operationdefinition.model.OperationDefinitionDTO;
import ai.stapi.graphsystem.operationdefinition.model.OperationDefinitionProvider;
import java.util.HashMap;
import java.util.Map;

public class FormMapper {
    private final JsonSchemaMapper jsonSchemaMapper;
    private final UISchemaLoader uiSchemaLoader;
    private final FormDataLoader formDataLoader;
    private final OperationDefinitionProvider operationDefinitionProvider;

    public FormMapper(JsonSchemaMapper jsonSchemaMapper, UISchemaLoader uiSchemaLoader, FormDataLoader formDataLoader, OperationDefinitionProvider operationDefinitionProvider) {
        this.jsonSchemaMapper = jsonSchemaMapper;
        this.uiSchemaLoader = uiSchemaLoader;
        this.formDataLoader = formDataLoader;
        this.operationDefinitionProvider = operationDefinitionProvider;
    }

    public FormMapperResult map(String operationId, FormRequest formRequest) {
        OperationDefinitionDTO operation = this.operationDefinitionProvider.provide(operationId);
        Map<String, Object> jsonSchema = this.jsonSchemaMapper.map(operation, formRequest.getOmitExtension());
        Map<String, Object> uiSchema = this.uiSchemaLoader.load(operation);
        return new FormMapperResult(jsonSchema, uiSchema, formRequest.getResourceId() == null ? new HashMap<String, Object>() : this.formDataLoader.load(operation, formRequest.getResourceId(), formRequest.getTargets()));
    }
}

